/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NoSchemeDBPropertiesPhysicalStorage
implements DBPropertiesPhysicalStorage {
    private final Map<String, String> table = new ConcurrentHashMap<String, String>();

    @Override
    public void putDbProperty(String key, String value, String oldValue) throws Exception {
        if (value != null) {
            this.table.put(key, value);
        } else {
            this.table.remove(key);
        }
    }

    @Override
    public String getDbProperty(String key) throws Exception {
        return this.table.get(key);
    }

    @Override
    public Map<String, String> getAllKeys() throws Exception {
        return Collections.unmodifiableMap(this.table);
    }

    public void save(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("db-properties");
        for (Map.Entry<String, String> property : this.table.entrySet()) {
            writer.writeStartElement("db-property");
            writer.writeAttribute("key", property.getKey());
            if (property.getValue() != null) {
                writer.writeAttribute("value", property.getValue());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void reset() {
        this.table.clear();
    }
}

