/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.DictionaryData;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSchemePhysicalDictionaryStorage
implements DictionaryPhysicalStorage {
    private static final Logger log = LoggerFactory.getLogger(NoSchemePhysicalDictionaryStorage.class);
    private final Map<String, DictionaryData> table = new ConcurrentHashMap<String, DictionaryData>();

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        return this.findDictionary(cls, null, code, deleted, session);
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        return this.findDictionary(cls, uid, null, ignoreDeleted ? Boolean.FALSE : null, session);
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        DictionaryData dictData = (DictionaryData)data.getContext().get(data.getUid());
        if (dictData == null) {
            dictData = this.findDictionaryData(data.getDictionaryType(), data.getUid(), null, data.isDeleted(), session);
        }
        if (dictData == null) {
            return;
        }
        this.delete(dictData);
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        DictionaryData dictData = (DictionaryData)data.getContext().get(data.getUid());
        if (dictData == null) {
            dictData = this.findDictionaryData(data.getDictionaryType(), data.getUid(), null, data.isDeleted(), session);
        }
        if (dictData == null) {
            dictData = new DictionaryData();
            dictData.setUid(data.getUid());
        }
        dictData.setData(data.getData());
        dictData.setDeleted(data.isDeleted());
        dictData.setCode(data.getCode());
        dictData.setDictId(data.getDictionaryType().getName());
        dictData.setCreated(data.getCreated());
        dictData.setModified(data.getModified());
        this.save(dictData);
        data.getContext().put(dictData.getUid(), dictData);
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSynce, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        ArrayList result = new ArrayList();
        String dictId = dictClass != null ? dictClass.getName() : null;
        for (DictionaryData data : new ArrayList<DictionaryData>(this.table.values())) {
            if (deleted != null && !deleted.equals(data.isDeleted()) || dictId != null && !dictId.equals(data.getDictionaryId()) || modifiedSynce != null && (data.getModified() == null || data.getModified().getTime() < modifiedSynce.getTime())) continue;
            boolean f = false;
            for (Class<?> type : ignoredTypes) {
                if (!type.getName().equals(data.getDictionaryId())) continue;
                f = true;
            }
            if (f) continue;
            result.add(NoSchemePhysicalDictionaryStorage.toPhysicalDictionaryData(data));
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, final SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (limit != null && limit <= 1) {
            return result;
        }
        ArrayList<TempRow> tmpList = new ArrayList<TempRow>();
        String dictId = cls.getName();
        for (DictionaryData data : new ArrayList<DictionaryData>(this.table.values())) {
            Date dateFiledValue;
            if (!dictId.equals(data.getDictionaryId()) || ignoreDeleted && data.isDeleted() || startDate != null && ((dateFiledValue = useCreateDate ? data.getCreated() : data.getModified()) == null || dateFiledValue.getTime() < startDate.getTime()) || endDate != null && ((dateFiledValue = useCreateDate ? data.getCreated() : data.getModified()) == null || dateFiledValue.getTime() >= endDate.getTime())) continue;
            if (sortOrder != null) {
                tmpList.add(new TempRow(data.getUid(), useCreateDate ? data.getCreated() : data.getModified()));
                if (limit == null || tmpList.size() < limit) continue;
                break;
            }
            result.add(data.getUid());
            if (limit == null || result.size() < limit) continue;
            break;
        }
        if (sortOrder != null) {
            if (tmpList.size() > 1) {
                Collections.sort(tmpList, new Comparator<TempRow>(){

                    @Override
                    public int compare(TempRow o1, TempRow o2) {
                        long time2;
                        if (o1.getDate() == null) {
                            return o2.getDate() == null ? 0 : 1;
                        }
                        if (o2.getDate() == null) {
                            return o1.getDate() == null ? 0 : -1;
                        }
                        long time1 = o1.getDate().getTime();
                        if (time1 == (time2 = o2.getDate().getTime())) {
                            return 0;
                        }
                        switch (sortOrder) {
                            case ASC: {
                                return time1 > time2 ? 1 : -1;
                            }
                            case DESC: {
                                return time1 > time2 ? -1 : 1;
                            }
                        }
                        return 1;
                    }
                });
            }
            for (TempRow row : tmpList) {
                result.add(row.getUid());
            }
        }
        return result;
    }

    public void save(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("dictionaries");
        for (Map.Entry<String, DictionaryData> dictionary : this.table.entrySet()) {
            writer.writeStartElement("dictionary");
            writer.writeAttribute("key", dictionary.getKey());
            DictionaryData data = dictionary.getValue();
            if (data != null) {
                writer.writeStartElement("uid");
                if (data.getUid() != null) {
                    writer.writeCharacters(data.getUid());
                }
                writer.writeEndElement();
                writer.writeStartElement("created");
                if (data.getCreated() != null) {
                    writer.writeCharacters(data.getCreated().toString());
                }
                writer.writeEndElement();
                writer.writeStartElement("modified");
                if (data.getModified() != null) {
                    writer.writeCharacters(data.getModified().toString());
                }
                writer.writeEndElement();
                writer.writeStartElement("dict-id");
                if (data.getDictionaryId() != null) {
                    writer.writeCharacters(data.getDictionaryId());
                }
                writer.writeEndElement();
                writer.writeStartElement("code");
                if (data.getCode() != null) {
                    writer.writeCharacters(data.getCode());
                }
                writer.writeEndElement();
                writer.writeStartElement("deleted");
                writer.writeCharacters(Boolean.toString(data.isDeleted()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public synchronized void reset() {
        this.table.clear();
    }

    private void save(DictionaryData data) {
        this.table.put(data.getUid(), data);
    }

    private void delete(DictionaryData data) {
        this.table.remove(data.getUid());
    }

    public <D extends BaseDictionary> DictionaryData findDictionaryData(Class<D> cls, String uid, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        DictionaryData result = null;
        String _code = !TextUtil.isBlank((String)code) ? code : null;
        String _uid = !TextUtil.isBlank((String)uid) ? uid : null;
        String dictId = cls.getName();
        for (DictionaryData data : new ArrayList<DictionaryData>(this.table.values())) {
            if (_code != null && !_code.equals(data.getCode()) || _uid != null && !_uid.equals(data.getUid()) || deleted != null && data.isDeleted() != deleted.booleanValue() || !dictId.equals(data.getDictionaryId())) continue;
            result = data;
            break;
        }
        if (result != null && !cls.getName().equals(result.getDictionaryId())) {
            log.warn(String.format("inconsistent ID for dictionary item data %s, expected %s, found %s", result.getUid(), cls.getName(), result.getDictionaryId()));
        }
        return result;
    }

    private <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionary(Class<D> cls, String uid, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        DictionaryData data = this.findDictionaryData(cls, uid, code, deleted, session);
        if (data == null) {
            return null;
        }
        return NoSchemePhysicalDictionaryStorage.toPhysicalDictionaryData(data);
    }

    private static <D extends BaseDictionary> PhysicalDictionaryData<D> toPhysicalDictionaryData(DictionaryData data) throws Exception {
        PhysicalDictionaryData result = new PhysicalDictionaryData();
        result.setUid(data.getUid());
        result.getContext().put(data.getUid(), data);
        result.setCode(data.getCode());
        result.setCreated(MiscUtil.cloneDate((Date)data.getCreated()));
        result.setData(data.getData());
        result.setDeleted(data.isDeleted());
        result.setDictionaryType(XHelper.getClass((String)data.getDictionaryId()));
        result.setModified(MiscUtil.cloneDate((Date)data.getModified()));
        return result;
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    private final class TempRow {
        private final String uid;
        private final Date date;

        public TempRow(String uid, Date date) {
            this.uid = uid;
            this.date = date;
        }

        public String getUid() {
            return this.uid;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

