/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.QueryComparisonHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemePhysicalStorageHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSchemePhysicalEntityStorage
implements EntityPhysicalStorage {
    private final ConcurrentMap<Class<?>, Map<String, PhysicalEntityData<?>>> allContainers = new ConcurrentHashMap();
    protected final ConcurrentMap<Class<?>, Map<String, List<BaseIndexData<?, ?>>>> allIndexes = new ConcurrentHashMap();
    protected final ConcurrentMap<Class<?>, Map<String, String>> aggregatedData = new ConcurrentHashMap();
    private final Lock ALL_CONTAINERS_LOCK = new ReentrantLock();
    private final Lock ALL_INDEXES_LOCK = new ReentrantLock();
    private final Lock ALL_AGGREGATED_DATA_LOCK = new ReentrantLock();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(final Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        this.log.debug(String.format("search: class = %s, query = %s", MiscUtil.getSimpleClassName(cls), query));
        ArrayList allData = new ArrayList();
        Map map = (Map)this.allIndexes.get(cls);
        if (map != null) {
            for (List batch : map.values()) {
                for (BaseIndexData data : batch) {
                    allData.add(data.toIndex(Collections.emptySet()));
                }
            }
        }
        return NoSchemePhysicalStorageHelper.search(allData, query, new QueryComparisonHelper.FieldValuesProvider<I>(){

            public Class<?> getFieldClass(String property) {
                if ("aggregatedData".equals(property)) {
                    return String.class;
                }
                if ("containerUid".equals(property)) {
                    return String.class;
                }
                if ("navigationKey".equals(property)) {
                    return String.class;
                }
                if ("uid".equals(property)) {
                    return String.class;
                }
                try {
                    IndexType it = (IndexType)MetaRegistry.get().getIndexes().get(cls.getName());
                    IndexProperty ip = (IndexProperty)it.getProperties().get(property);
                    if (ip != null) {
                        return this.getType(ip.getType());
                    }
                    IndexCollection ic = (IndexCollection)it.getCollections().get(property);
                    if (ic != null) {
                        return this.getType(ic.getType());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return String.class;
            }

            private Class<?> getType(String type) throws ClassNotFoundException {
                Class result = QueryComparisonHelper.getType((String)type);
                if (result != null && DictionaryReference.class.isAssignableFrom(result)) {
                    return DictionaryReference.class;
                }
                if (result != null && BaseEntity.class.isAssignableFrom(result)) {
                    return BaseEntity.class;
                }
                return result;
            }

            public Object getFieldValue(I object, String property) {
                if ("aggregatedData".equals(property)) {
                    Map agmap = (Map)NoSchemePhysicalEntityStorage.this.aggregatedData.get(cls);
                    return agmap == null ? null : agmap.get(object.getUid());
                }
                if ("containerUid".equals(property)) {
                    return object.getSource().getUid();
                }
                if ("navigationKey".equals(property)) {
                    return object.getNavigationKey();
                }
                if ("uid".equals(property)) {
                    return object.getUid();
                }
                if ("entityType".equals(property)) {
                    return object.getSource().getType().getName();
                }
                Object value = object.getValue(property);
                if (value instanceof EntityReference) {
                    EntityReference ref = (EntityReference)value;
                    return ref.getUid();
                }
                if (value instanceof DictionaryReference) {
                    DictionaryReference ref = (DictionaryReference)value;
                    return ref.getCode();
                }
                return value;
            }
        });
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException("projections search is not supported by this (NoSql) storage");
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        PhysicalEntityData data = this.load(cls, uid);
        if (data == null) {
            return null;
        }
        PhysicalEntityData result = new PhysicalEntityData();
        data.copy(result);
        final int version = versionNumber == null ? data.getVersionsCount() - 1 : versionNumber;
        CollectionUtil.filter(result.getVersions(), (ObjectFilter)new ObjectFilter<PhysicalVersionData>(){

            public boolean accept(PhysicalVersionData object) {
                return object.getVersionNumber() == version;
            }
        });
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, final int ... versionNumbers) throws Exception {
        PhysicalEntityData<E> data = this.load(entityData.getEntityType(), entityData.getUid());
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<PhysicalVersionData> result = new ArrayList<PhysicalVersionData>();
        result.addAll(data.getVersions());
        CollectionUtil.filter(result, (ObjectFilter)new ObjectFilter<PhysicalVersionData>(){

            public boolean accept(PhysicalVersionData object) {
                for (int version : versionNumbers) {
                    if (object.getVersionNumber() != version) continue;
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> entityData, PhysicalStorageSession session) throws Exception {
        ArrayList<PhysicalVersionMetadataData> result = new ArrayList<PhysicalVersionMetadataData>();
        PhysicalEntityData<E> data = this.load(entityData.getType(), entityData.getUid());
        int[] versionNumbers = new int[data.getVersionsCount()];
        for (int n = 0; n < data.getVersionsCount(); ++n) {
            versionNumbers[n] = n;
        }
        for (PhysicalVersionData vd : this.getVersions(data, session, versionNumbers)) {
            PhysicalVersionMetadataData item = new PhysicalVersionMetadataData();
            item.setCreated(vd.getCreated());
            item.setCreatedBy(vd.getCreatedBy());
            item.setDataFormat(vd.getDataFormat());
            item.setDataSource(vd.getDataSource());
            item.setModified(vd.getModified());
            item.setUid(vd.getUid());
            item.setVersionNotes(vd.getVersionNotes());
            item.setVersionNumber(vd.getVersionNumber());
            result.add(vd);
        }
        return result;
    }

    private <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> List<D> getIndexes(Map<EntityPhysicalStorage, List<D>> data) {
        List<D> indexes = data.get(this);
        if (indexes != null) {
            return indexes;
        }
        return data.values().stream().findFirst().orElse(Collections.emptyList());
    }

    @Override
    public synchronized <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> cls, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
        Map map = (Map)this.allIndexes.get(cls);
        if (map == null) {
            return;
        }
        Map<EntityPhysicalStorage, List<D>> data = this.getIndexes(cls, containerUid, session);
        List indexes = data.values().stream().findFirst().orElse(Collections.emptyList());
        map.remove(containerUid);
        for (BaseIndexData idx : indexes) {
            ((Map)this.aggregatedData.get(cls)).remove(idx.getUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> cls, Map<EntityPhysicalStorage, List<D>> data, String containerUid, PhysicalStorageSession session) throws Exception {
        ConcurrentHashMap<String, List<D>> map = (ConcurrentHashMap<String, List<D>>)this.allIndexes.get(cls);
        if (map == null) {
            Lock lock = this.ALL_INDEXES_LOCK;
            lock.lock();
            try {
                map = (Map)this.allIndexes.get(cls);
                if (map == null) {
                    map = new ConcurrentHashMap<String, List<D>>();
                    this.allIndexes.put(cls, map);
                }
            }
            finally {
                lock.unlock();
            }
        }
        List<D> indexes = this.getIndexes(data);
        map.put(containerUid, indexes);
        ConcurrentHashMap<String, String> map2 = (ConcurrentHashMap<String, String>)this.aggregatedData.get(cls);
        if (map2 == null) {
            Lock lock = this.ALL_AGGREGATED_DATA_LOCK;
            lock.lock();
            try {
                map2 = (Map)this.aggregatedData.get(cls);
                if (map2 == null) {
                    map2 = new ConcurrentHashMap<String, String>();
                    this.aggregatedData.put(cls, map2);
                }
            }
            finally {
                lock.unlock();
            }
        }
        for (BaseIndexData item : indexes) {
            map2.put(item.getUid(), item.getAggregatedData() == null ? "" : item.getAggregatedData());
        }
    }

    @Override
    public <E extends BaseEntity> void saveEntity(final PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        PhysicalEntityData<E> data = this.load(etc.getEntityType(), etc.getUid());
        if (data == null) {
            this.save(etc);
            return;
        }
        CollectionUtil.filter(data.getVersions(), (ObjectFilter)new ObjectFilter<PhysicalVersionData>(){

            public boolean accept(PhysicalVersionData object) {
                for (PhysicalVersionData item : etc.getVersions()) {
                    if (item.getVersionNumber() != object.getVersionNumber()) continue;
                    return false;
                }
                return true;
            }
        });
        etc.getVersions().addAll(data.getVersions());
        Collections.sort(etc.getVersions(), new Comparator<PhysicalVersionData>(){

            @Override
            public int compare(PhysicalVersionData o1, PhysicalVersionData o2) {
                return o1.getVersionNumber() - o2.getVersionNumber();
            }
        });
        this.save(etc);
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        this.delete(data);
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, final int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        PhysicalEntityData<E> ped = this.load(data.getEntityType(), data.getUid());
        if (ped == null) {
            return;
        }
        CollectionUtil.filter(ped.getVersions(), (ObjectFilter)new ObjectFilter<PhysicalVersionData>(){

            public boolean accept(PhysicalVersionData object) {
                return object.getVersionNumber() != versionNumber;
            }
        });
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
        Map map = (Map)this.allIndexes.get(indexClass);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.containsKey(uid) ? Collections.singletonMap(this, (List)map.get(uid)) : Collections.emptyMap();
    }

    @Override
    public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
        ArrayList<PhysicalEntityDataModification> result = new ArrayList<PhysicalEntityDataModification>();
        for (Map.Entry entry : this.allContainers.entrySet()) {
            if (!types.contains(entry.getKey())) continue;
            for (PhysicalEntityData data : ((Map)entry.getValue()).values()) {
                if (timeStampFrom != null && timeStampFrom.after(data.getModified()) || timeStampTo != null && timeStampTo.before(data.getModified())) continue;
                PhysicalEntityDataModification item = new PhysicalEntityDataModification();
                item.setEntityType(data.getEntityType());
                item.setModified(data.getModified());
                item.setUid(data.getUid());
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        PhysicalEntityData<E> ctr = this.load(cls, uid);
        return ctr != null && ctr.getStatus() != EntityStatus.VOID;
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, final boolean useCreateDate, boolean ignoreVoid, final SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        List<PhysicalEntityData> items = new ArrayList();
        for (Map.Entry entry : this.allContainers.entrySet()) {
            if (cls != null && !cls.equals(entry.getKey())) continue;
            for (PhysicalEntityData data : ((Map)entry.getValue()).values()) {
                Date date;
                if (!ignoreVoid && data.getStatus() == EntityStatus.VOID) continue;
                Date date2 = date = useCreateDate ? data.getCreated() : data.getModified();
                if (startDate != null && startDate.after(date) || endDate != null && !endDate.after(date)) continue;
                items.add(data);
            }
        }
        Collections.sort(items, new Comparator<PhysicalEntityData<?>>(){

            @Override
            public int compare(PhysicalEntityData<?> o1, PhysicalEntityData<?> o2) {
                return sortOrder == SortOrder.ASC ? MiscUtil.compare((Date)this.getDate(o1), (Date)this.getDate(o1)) : -MiscUtil.compare((Date)this.getDate(o1), (Date)this.getDate(o1));
            }

            private Date getDate(PhysicalEntityData<?> o1) {
                return useCreateDate ? o1.getCreated() : o1.getModified();
            }
        });
        if (limit != null && items.size() > limit) {
            items = items.subList(0, limit);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PhysicalEntityData item : items) {
            result.add(item.getUid());
        }
        return result;
    }

    private <E extends BaseEntity> PhysicalEntityData<E> load(Class<E> cls, String uid) {
        Map map = (Map)this.allContainers.get(cls);
        if (map == null) {
            return null;
        }
        return (PhysicalEntityData)map.get(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BaseEntity> void save(PhysicalEntityData<E> data) {
        ConcurrentHashMap<String, PhysicalEntityData<E>> map = (ConcurrentHashMap<String, PhysicalEntityData<E>>)this.allContainers.get(data.getEntityType());
        if (map == null) {
            Lock lock = this.ALL_CONTAINERS_LOCK;
            lock.lock();
            try {
                map = (Map)this.allContainers.get(data.getEntityType());
                if (map == null) {
                    map = new ConcurrentHashMap<String, PhysicalEntityData<E>>();
                    this.allContainers.put(data.getEntityType(), map);
                }
            }
            finally {
                lock.unlock();
            }
        }
        map.put(data.getUid(), data);
    }

    private <E extends BaseEntity> void delete(PhysicalEntityData<E> data) {
        Map map = (Map)this.allContainers.get(data.getEntityType());
        if (map == null) {
            return;
        }
        map.remove(data.getUid());
    }

    synchronized void reset() {
        this.allContainers.clear();
        this.allIndexes.clear();
        this.aggregatedData.clear();
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void save(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("entities");
        for (Map.Entry classes : this.allContainers.entrySet()) {
            writer.writeStartElement("type");
            writer.writeAttribute("class", ((Class)classes.getKey()).getName());
            for (Map.Entry entity : ((Map)classes.getValue()).entrySet()) {
                writer.writeStartElement("entity");
                writer.writeAttribute("key", (String)entity.getKey());
                PhysicalEntityData data = (PhysicalEntityData)entity.getValue();
                writer.writeAttribute("class", data != null ? data.getClass().getName() : ((Class)classes.getKey()).getName());
                if (data != null) {
                    writer.writeStartElement("uid");
                    if (data.getUid() != null) {
                        writer.writeCharacters(data.getUid());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("created");
                    if (data.getCreated() != null) {
                        writer.writeCharacters(data.getCreated().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("modified");
                    if (data.getModified() != null) {
                        writer.writeCharacters(data.getModified().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("created-by");
                    if (data.getCreatedBy() != null) {
                        writer.writeCharacters(data.getCreatedBy());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("modified-by");
                    if (data.getModifiedBy() != null) {
                        writer.writeCharacters(data.getModifiedBy());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("entity-type");
                    if (data.getEntityType() != null) {
                        writer.writeCharacters(data.getEntityType().getName());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("status");
                    if (data.getStatus() != null) {
                        writer.writeCharacters(data.getStatus().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("versions-count");
                    writer.writeCharacters(Integer.toString(data.getVersionsCount()));
                    writer.writeEndElement();
                    writer.writeStartElement("updatePolicy");
                    if (data.getUpdatePolicy() != null) {
                        writer.writeCharacters(data.getUpdatePolicy().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("revision");
                    writer.writeCharacters(Long.toString(data.getRevision()));
                    writer.writeEndElement();
                    if (data.getVersions() != null && data.getVersions().size() != 0) {
                        writer.writeStartElement("versions");
                        for (PhysicalVersionData version : data.getVersions()) {
                            writer.writeStartElement("version");
                            writer.writeStartElement("uid");
                            if (version.getUid() != null) {
                                writer.writeCharacters(version.getUid());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("created");
                            if (version.getCreated() != null) {
                                writer.writeCharacters(version.getCreated().toString());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("modified");
                            if (version.getModified() != null) {
                                writer.writeCharacters(version.getModified().toString());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("created-by");
                            if (version.getCreatedBy() != null) {
                                writer.writeCharacters(version.getCreatedBy());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("modified-by");
                            if (version.getModifiedBy() != null) {
                                writer.writeCharacters(version.getModifiedBy());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("version-number");
                            writer.writeCharacters(Integer.toString(version.getVersionNumber()));
                            writer.writeEndElement();
                            writer.writeStartElement("data-source");
                            if (version.getDataSource() != null) {
                                writer.writeCharacters(version.getDataSource().toString());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("version-notes");
                            if (version.getVersionNotes() != null) {
                                writer.writeCharacters(version.getVersionNotes());
                            }
                            writer.writeEndElement();
                            writer.writeStartElement("data-format");
                            if (version.getDataFormat() != null) {
                                writer.writeCharacters(version.getDataFormat().toString());
                            }
                            writer.writeEndElement();
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("indexes");
        for (Map.Entry classes : this.allIndexes.entrySet()) {
            writer.writeStartElement("type");
            writer.writeAttribute("class", ((Class)classes.getKey()).getName());
            for (Map.Entry indexScope : ((Map)classes.getValue()).entrySet()) {
                writer.writeStartElement("index-scope");
                writer.writeAttribute("key", (String)indexScope.getKey());
                for (BaseIndexData index : (List)indexScope.getValue()) {
                    writer.writeStartElement("index");
                    writer.writeAttribute("key", (String)indexScope.getKey());
                    writer.writeAttribute("class", index.getClass().getName());
                    writer.writeStartElement("uid");
                    if (index.getUid() != null) {
                        writer.writeCharacters(index.getUid().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("modified");
                    if (index.getModified() != null) {
                        writer.writeCharacters(index.getModified().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("reference-caption");
                    if (index.getReferenceCaption() != null) {
                        writer.writeCharacters(index.getReferenceCaption().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("navigation-key");
                    if (index.getNavigationKey() != null) {
                        writer.writeCharacters(index.getNavigationKey().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("aggregated-data");
                    if (index.getAggregatedData() != null) {
                        writer.writeCharacters(index.getAggregatedData().toString());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("entity-type");
                    if (index.getEntityType() != null) {
                        writer.writeCharacters(index.getEntityType());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("container-uid");
                    if (index.getContainerUid() != null) {
                        writer.writeCharacters(index.getContainerUid());
                    }
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("aggregated-datas");
        for (Map.Entry classes : this.aggregatedData.entrySet()) {
            writer.writeStartElement("type");
            writer.writeAttribute("class", ((Class)classes.getKey()).getName());
            for (Map.Entry data : ((Map)classes.getValue()).entrySet()) {
                writer.writeStartElement("aggregated-data");
                writer.writeAttribute("key", (String)data.getKey());
                if (data.getValue() != null) {
                    writer.writeCharacters((String)data.getValue());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        return this.load(cls, uid) != null;
    }
}

