/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemeAssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemeBulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemeDBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemePhysicalDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemePhysicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemePhysicalStorageSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class NoSchemePhysicalStorage
implements PhysicalStorage {
    private final String uid;
    private final NoSchemePhysicalEntityStorage entityStorage;
    private final NoSchemePhysicalDictionaryStorage dictionaryStorage = new NoSchemePhysicalDictionaryStorage();
    private final NoSchemeBulkDictionaryPhysicalStorage bulkDictionaryStorage = new NoSchemeBulkDictionaryPhysicalStorage();
    private final NoSchemeAssetPhysicalStorage assetPhysicalStorage = new NoSchemeAssetPhysicalStorage();
    private final NoSchemeDBPropertiesPhysicalStorage dbPropertiesStorage = new NoSchemeDBPropertiesPhysicalStorage();

    public NoSchemePhysicalStorage(String storageUid) {
        this.uid = storageUid;
        this.entityStorage = new NoSchemePhysicalEntityStorage();
    }

    public NoSchemePhysicalStorage(String storageUid, NoSchemePhysicalEntityStorage storage) {
        this.uid = storageUid;
        this.entityStorage = storage;
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        return new NoSchemePhysicalStorageSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream out) throws Exception {
        XMLOutputFactory output = XSUtil.getXMLOutputFactory();
        try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)output.createXMLStreamWriter(out));){
            writer.writeStartDocument();
            writer.writeStartElement("noscheme");
            this.entityStorage.save(writer);
            this.assetPhysicalStorage.save(writer);
            this.dictionaryStorage.save(writer);
            this.bulkDictionaryStorage.save(writer);
            this.dbPropertiesStorage.save(writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
    }

    public void save(File file) throws Exception {
        FileOutputStream out = new FileOutputStream(file);
        try {
            this.save(out);
        }
        finally {
            out.flush();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        try {
            this.save(out);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        if (cleanupMode) {
            this.entityStorage.reset();
        }
    }

    @Override
    public boolean checkHealth() {
        return true;
    }

    @Override
    public void dispose() {
        this.entityStorage.reset();
        this.dictionaryStorage.reset();
        this.bulkDictionaryStorage.reset();
        this.assetPhysicalStorage.reset();
        this.dbPropertiesStorage.reset();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetPhysicalStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.dbPropertiesStorage;
    }

    @Override
    public void maintain() throws Exception {
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}

