/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.QueryComparisonHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public final class NoSchemePhysicalStorageHelper {
    public static final String AGGREGATED_DATA = "aggregatedData";
    public static final String CONTAINER_UID = "containerUid";
    public static final String UID = "uid";
    public static final String ENTITY_TYPE = "entityType";
    public static final String NAVIGATION_KEY = "navigationKey";
    static final Map<Class<?>, Comparator<?>> comparators = new HashMap();

    public static <T> SearchResult<T> search(Collection<T> data, SearchQuery query, final QueryComparisonHelper.FieldValuesProvider<T> provider) {
        Map orders;
        ArrayList<T> filteredList = new ArrayList<T>();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>(query.getCriteria().getCriterions());
        if (query.getCriteria().getFreeTextPattern() != null) {
            criterions.add(SearchCriterion.contains((String)AGGREGATED_DATA, (Object)query.getCriteria().getFreeTextPattern()));
        }
        for (T item : data) {
            if (!QueryComparisonHelper.matchCriterions(item, criterions, provider)) continue;
            filteredList.add(item);
        }
        ResultMode resultMode = query.getResultMode();
        if (resultMode != ResultMode.COUNT_ONLY && !(orders = query.getCriteria().getOrders()).isEmpty()) {
            Collections.sort(filteredList, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    for (Map.Entry order : orders.entrySet()) {
                        Object fieldVal2;
                        Object fieldVal1;
                        Class fieldClass;
                        Comparator<?> fieldCmp;
                        int res;
                        String fieldName = (String)order.getKey();
                        if (provider instanceof QueryComparisonHelper.FieldValuesProviderEx) {
                            fieldName = ((QueryComparisonHelper.FieldValuesProviderEx)provider).getSortProperty(fieldName);
                        }
                        if ((res = (fieldCmp = comparators.get(fieldClass = provider.getFieldClass(fieldName))).compare(fieldVal1 = provider.getFieldValue(o1, fieldName), fieldVal2 = provider.getFieldValue(o2, fieldName))) == 0) continue;
                        return order.getValue() == SortOrder.ASC ? res : -res;
                    }
                    return 0;
                }
            });
        }
        SearchResult result = new SearchResult();
        result.setTimestamp(new Date());
        if (resultMode != ResultMode.DATA_ONLY) {
            result.setTotalCount(filteredList.size());
        }
        if (resultMode != ResultMode.COUNT_ONLY) {
            for (final FilterQuery filter : query.getFilters()) {
                LinkedHashSet<Object> filterData = new LinkedHashSet<Object>();
                for (Object item : filteredList) {
                    Object value = provider.getFieldValue(item, filter.getProperty());
                    if (value == null) continue;
                    filterData.add(value);
                }
                ArrayList sortedFilterData = new ArrayList(filterData);
                final Class cls = provider.getFieldClass(filter.getProperty());
                Collections.sort(sortedFilterData, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        Comparator<?> comparator = comparators.get(cls);
                        int res = comparator.compare(o1, o2);
                        return filter.getSortOrder() == SortOrder.ASC ? res : -res;
                    }
                });
                result.getFilter(filter.getProperty()).addAll(sortedFilterData);
            }
            int startPosition = query.getOffset();
            int endPosition = query.getOffset() + query.getLimit();
            if (query.getLimit() == 0 || endPosition > result.getTotalCount()) {
                endPosition = result.getTotalCount();
            }
            if (startPosition == 0 && endPosition == result.getTotalCount()) {
                result.getData().addAll(filteredList);
            } else {
                result.getData().addAll(filteredList.subList(startPosition, endPosition));
            }
            if (ResultMode.DATA_ONLY == resultMode && (query.getOffset() != 0 || query.getLimit() > 0)) {
                result.setTotalCount(-1);
            }
        }
        return result;
    }

    private NoSchemePhysicalStorageHelper() {
    }

    static {
        comparators.put(String.class, new StandardComparator());
        comparators.put(DictionaryReference.class, new Comparator<DictionaryReference<?>>(){

            @Override
            public int compare(DictionaryReference<?> o1, DictionaryReference<?> o2) {
                return TextUtil.compare((String)MiscUtil.toString(o1), (String)MiscUtil.toString(o2), (boolean)false, (boolean)false);
            }
        });
        comparators.put(Enum.class, new Comparator<Enum<?>>(){

            @Override
            public int compare(Enum<?> o1, Enum<?> o2) {
                return TextUtil.compare((String)MiscUtil.toString(o1), (String)MiscUtil.toString(o2), (boolean)false, (boolean)false);
            }
        });
        comparators.put(BaseEntity.class, new Comparator<BaseEntity>(){

            @Override
            public int compare(BaseEntity o1, BaseEntity o2) {
                return TextUtil.compare((String)MiscUtil.toString((Object)o1), (String)MiscUtil.toString((Object)o2), (boolean)false, (boolean)false);
            }
        });
        comparators.put(L10nString.class, new Comparator<L10nString>(){

            @Override
            public int compare(L10nString o1, L10nString o2) {
                return TextUtil.compare((String)MiscUtil.toString((Object)o1), (String)MiscUtil.toString((Object)o2), (boolean)false, (boolean)false);
            }
        });
        comparators.put(Boolean.class, new StandardComparator());
        comparators.put(Byte.class, new StandardComparator());
        comparators.put(Character.class, new StandardComparator());
        comparators.put(Short.class, new StandardComparator());
        comparators.put(Integer.class, new StandardComparator());
        comparators.put(Double.class, new StandardComparator());
        comparators.put(Long.class, new StandardComparator());
        comparators.put(Float.class, new StandardComparator());
        comparators.put(BigDecimal.class, new StandardComparator());
        comparators.put(BigInteger.class, new StandardComparator());
        comparators.put(Date.class, new StandardComparator());
        comparators.put(Object.class, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return TextUtil.compare((String)MiscUtil.toString((Object)o1), (String)MiscUtil.toString((Object)o2), (boolean)false, (boolean)false);
            }
        });
        comparators.put(byte[].class, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (Arrays.equals(o1, o2)) {
                    return 0;
                }
                return this.getLength(o1) - this.getLength(o2);
            }

            private int getLength(byte[] obj) {
                return obj == null ? 0 : obj.length;
            }
        });
    }

    static final class StandardComparator<C extends Comparable<C>>
    implements Comparator<C> {
        StandardComparator() {
        }

        @Override
        public int compare(C o1, C o2) {
            return MiscUtil.compare(o1, o2);
        }
    }
}

