/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageDeleteAssetOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageSaveAssetOperation;
import java.util.Date;
import java.util.List;

class ReplicationAssetStorage
implements AssetPhysicalStorage {
    ReplicationAssetStorage() {
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getAssetStorage().searchAssets(cls, query, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getAssetStorage().searchAssets(cls, query, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new AssetStorageSaveAssetOperation<A>(asset, restoreData));
        castedSession.getBoundSubstorage().getAssetStorage().saveAsset(asset, restoreData, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new AssetStorageDeleteAssetOperation<A>(asset));
        castedSession.getBoundSubstorage().getAssetStorage().deleteAsset(asset, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getAssetStorage().loadAsset(cls, uid, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getAssetStorage().getAssetUids(cls, startDate, endDate, sortOrder, limit, castedSession.getBoundSubsession());
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getAssetStorage().isAssetExist(cls, uid, castedSession.getBoundSubsession());
    }
}

