/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageDeleteDataOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageUpdateDataOperation;
import java.util.List;

class ReplicationBulkDictionaryStorage
implements BulkDictionaryPhysicalStorage {
    ReplicationBulkDictionaryStorage() {
    }

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getBulkDictionaryStorage().loadMetadata(castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getBulkDictionaryStorage().loadData(key, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new BulkDictionaryStorageUpdateDataOperation<D>(data, restoreData));
        castedSession.getBoundSubstorage().getBulkDictionaryStorage().updateData(data, restoreData, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new BulkDictionaryStorageDeleteDataOperation<D>(data));
        castedSession.getBoundSubstorage().getBulkDictionaryStorage().deleteData(data, castedSession.getBoundSubsession());
    }
}

