/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicationDBPropertiesStorage
implements DBPropertiesPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final ReplicationPhysicalStorage replicationStorage;

    public ReplicationDBPropertiesStorage(ReplicationPhysicalStorage replicationStorage) {
        this.replicationStorage = replicationStorage;
    }

    @Override
    public void putDbProperty(String key, String value, String oldValue) throws Exception {
        ArrayList<PutDBPropertyCallable> tasks = new ArrayList<PutDBPropertyCallable>(this.replicationStorage.getSubstorageCount());
        for (int i = 0; i < this.replicationStorage.getSubstorageCount(); ++i) {
            tasks.add(new PutDBPropertyCallable(this.replicationStorage.getSubstorages().get(i), key, value));
        }
        List futures = this.replicationStorage.getExecutorService().invokeAll(tasks);
        tasks.clear();
        for (int i = 0; i < this.replicationStorage.getSubstorageCount(); ++i) {
            PhysicalStorage substorage = this.replicationStorage.getSubstorages().get(i);
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("putDbProperty succeeded for substorage %s", substorage.getUid()));
                continue;
            }
            catch (Throwable t) {
                this.log.error(String.format("putDbProperty failed for substorage %s", this.replicationStorage.getSubstorages().get(i).getUid()), t);
                tasks.add(new PutDBPropertyCallable(substorage, key, oldValue));
            }
        }
        if (tasks.size() > 0) {
            this.replicationStorage.getExecutorService().invokeAll(tasks);
            throw new Exception("putDbProperty failed");
        }
    }

    @Override
    public String getDbProperty(String key) throws Exception {
        return this.replicationStorage.getSubstorages().get(this.replicationStorage.getBoundSubstorageIndex()).getDBPropertiesStorage().getDbProperty(key);
    }

    @Override
    public Map<String, String> getAllKeys() throws Exception {
        return this.replicationStorage.getSubstorages().get(this.replicationStorage.getBoundSubstorageIndex()).getDBPropertiesStorage().getAllKeys();
    }

    private class PutDBPropertyCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;
        private final String key;
        private final String value;

        PutDBPropertyCallable(PhysicalStorage substorage, String key, String value) {
            this.substorage = substorage;
            this.key = key;
            this.value = value;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.getDBPropertiesStorage().putDbProperty(this.key, this.value, null);
            return null;
        }
    }
}

