/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteAllOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageSaveDictionaryOperation;
import java.util.Date;
import java.util.List;
import java.util.Set;

class ReplicationDictionaryStorage
implements DictionaryPhysicalStorage {
    ReplicationDictionaryStorage() {
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getDictionaryStorage().findDictionaryByCode(cls, code, deleted, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageDeleteDictionaryOperation<D>(data));
        castedSession.getBoundSubstorage().getDictionaryStorage().deleteDictionary(data, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageSaveDictionaryOperation<D>(data, oldData));
        castedSession.getBoundSubstorage().getDictionaryStorage().saveDictionary(data, oldData, castedSession.getBoundSubsession());
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSynce, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getDictionaryStorage().loadAll(modifiedSynce, deleted, dictClass, ignoredTypes, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        return castedSession.getBoundSubstorage().getDictionaryStorage().getDictionaryUids(cls, startDate, endDate, useCreateDate, ignoreDeleted, sortOrder, limit, castedSession.getBoundSubsession());
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageDeleteAllOperation(cls));
        castedSession.getBoundSubstorage().getDictionaryStorage().deleteAll(cls, castedSession.getBoundSubsession());
    }
}

