/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationAssetStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationDBPropertiesStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationEntityStorage;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorageSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationPhysicalStorage
implements PhysicalStorage {
    private final List<PhysicalStorage> substorages;
    private final List<String> substorageUids;
    private final List<Boolean> substorageRead;
    private final int substorageCount;
    private final ExecutorServiceFacade executorService;
    private final ReplicationEntityStorage entityStorage;
    private final ReplicationDictionaryStorage dictionaryStorage;
    private final ReplicationBulkDictionaryStorage bulkDictionaryStorage;
    private final ReplicationAssetStorage assetStorage;
    private final ReplicationDBPropertiesStorage dbPropertiesStorage;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String uid;
    private final Random rnd = new Random();

    public ReplicationPhysicalStorage(ReplicationPhysicalStorageConfiguration configuration) throws Exception {
        this.log.debug("initializing...");
        this.uid = configuration.getUid();
        this.log.debug("creating substorages...");
        this.substorageCount = configuration.getStorageConfigs().size();
        this.substorages = new ArrayList<PhysicalStorage>(this.substorageCount);
        this.substorageUids = new ArrayList<String>(this.substorageCount);
        this.substorageRead = new ArrayList<Boolean>(this.substorageCount);
        for (ReplicationPhysicalStorageConfiguration.SubstorageConfiguration config : configuration.getStorageConfigs().values()) {
            PhysicalStorage storage = (PhysicalStorage)Class.forName(config.className).getConstructor(config.configuration.getClass()).newInstance(config.configuration);
            this.substorages.add(storage);
            this.substorageUids.add(storage.getUid());
            this.substorageRead.add(config.read);
            LogicalStorageRegistry.get().registerPhysicalStorage(storage);
            this.log.debug(String.format("created substorage %s", storage.getUid()));
        }
        this.log.debug("creating executor service...");
        this.executorService = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newCachedThreadPool("replication-physical-storage");
        this.log.debug("creating entity storage...");
        this.entityStorage = new ReplicationEntityStorage();
        this.log.debug("creating dictionary storage...");
        this.dictionaryStorage = new ReplicationDictionaryStorage();
        this.log.debug("creating bulk dictionary storage...");
        this.bulkDictionaryStorage = new ReplicationBulkDictionaryStorage();
        this.log.debug("creating asset storage...");
        this.assetStorage = new ReplicationAssetStorage();
        this.log.debug("creating db properties storage...");
        this.dbPropertiesStorage = new ReplicationDBPropertiesStorage(this);
        this.log.debug("initialized");
    }

    public void setSubstorageRead(String substorageUid, boolean value) throws Exception {
        int idx = this.substorageUids.indexOf(substorageUid);
        if (idx < 0) {
            throw new Exception(String.format("substorage %s not found", substorageUid));
        }
        this.substorageRead.set(idx, value);
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        int idx = this.getBoundSubstorageIndex();
        PhysicalStorage boundSubstorage = this.substorages.get(idx);
        PhysicalStorageSession boundSubsession = boundSubstorage.createSession(context);
        this.log.debug("session created");
        return new ReplicationPhysicalStorageSession(boundSubstorage, boundSubsession, this, context);
    }

    int getSubstorageCount() {
        return this.substorageCount;
    }

    ExecutorServiceFacade getExecutorService() {
        return this.executorService;
    }

    public List<PhysicalStorage> getSubstorages() {
        return this.substorages;
    }

    int getBoundSubstorageIndex() throws Exception {
        ArrayList<Integer> boundSubstorages = new ArrayList<Integer>();
        for (int i = 0; i < this.substorageCount; ++i) {
            if (!this.substorageRead.get(i).booleanValue()) continue;
            boundSubstorages.add(i);
        }
        if (boundSubstorages.size() == 0) {
            throw new Exception("no read substorage available");
        }
        int idx = 0;
        if (boundSubstorages.size() > 1) {
            idx = this.rnd.nextInt(boundSubstorages.size() - 1);
        }
        this.log.debug(String.format("selected bound substorage %s", this.substorageUids.get(idx)));
        return (Integer)boundSubstorages.get(idx);
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        ArrayList<SetupSchemeCallable> tasks = new ArrayList<SetupSchemeCallable>(this.substorageCount);
        for (int i = 0; i < this.substorageCount; ++i) {
            tasks.add(new SetupSchemeCallable(this.substorages.get(i), cleanupMode));
        }
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < this.substorageCount; ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("setupScheme succeeded for substorage %s", this.substorageUids.get(i)));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.error(String.format("setupScheme failed for substorage %s", this.substorageUids.get(i)), t);
            }
        }
        if (!success) {
            throw new Exception("setupScheme failed");
        }
    }

    @Override
    public boolean checkHealth() {
        boolean health = true;
        for (int i = 0; i < this.substorageCount; ++i) {
            if (this.substorages.get(i).checkHealth()) continue;
            this.log.error("checkHealth failed for substorage " + this.substorageUids.get(i));
            health = false;
        }
        return health;
    }

    @Override
    public void dispose() {
        ArrayList<DisposeCallable> tasks = new ArrayList<DisposeCallable>(this.substorageCount);
        for (int i = 0; i < this.substorageCount; ++i) {
            tasks.add(new DisposeCallable(this.substorages.get(i)));
        }
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (Throwable t) {
            this.log.error("failed disposing substorages", t);
        }
        this.executorService.dispose();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.dbPropertiesStorage;
    }

    @Override
    public void maintain() throws Exception {
        ArrayList<MaintainCallable> tasks = new ArrayList<MaintainCallable>(this.substorageCount);
        for (int i = 0; i < this.substorageCount; ++i) {
            tasks.add(new MaintainCallable(this.substorages.get(i)));
        }
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < this.substorageCount; ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("maintain succeeded for substorage %s", this.substorageUids.get(i)));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.error(String.format("maintain failed for substorage %s", this.substorageUids.get(i)), t);
            }
        }
        if (!success) {
            throw new Exception("maintain failed");
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
        ReplicationPhysicalStorageSession castedSession = (ReplicationPhysicalStorageSession)session;
        ArrayList<Callable<Map>> ops = new ArrayList<Callable<Map>>(this.substorageCount);
        int i = 0;
        while (i < this.substorageCount) {
            int idx = i++;
            ops.add(() -> {
                Map map;
                PhysicalStorage boundSubstorage = castedSession.getBoundSubstorage();
                PhysicalStorage substorage = this.substorages.get(idx);
                if (substorage == boundSubstorage) {
                    return castedSession.getBoundSubstorage().getEntityStorage().getIndexes(indexClass, uid, castedSession.getBoundSubsession());
                }
                PhysicalStorageSession subsession = substorage.createSession(castedSession.getContext());
                try {
                    this.log.debug(String.format("|substorage=%s| subsession created", substorage.getUid()));
                    map = substorage.getEntityStorage().getIndexes(indexClass, uid, subsession);
                }
                catch (Throwable t) {
                    try {
                        this.log.error(String.format("|substorage=%s| get indexes failed", substorage.getUid()), t);
                        throw t;
                    }
                    catch (Throwable throwable) {
                        subsession.close();
                        this.log.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
                        throw throwable;
                    }
                }
                subsession.close();
                this.log.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
                return map;
            });
        }
        List futures = this.getExecutorService().invokeAll(ops);
        HashMap<EntityPhysicalStorage, List<D>> result = new HashMap<EntityPhysicalStorage, List<D>>();
        for (int i2 = 0; i2 < futures.size(); ++i2) {
            Map data = (Map)((Future)futures.get(i2)).get();
            if (data == null) continue;
            result.putAll(data);
        }
        return result;
    }

    private static class MaintainCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        MaintainCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.maintain();
            return null;
        }
    }

    private static class DisposeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        DisposeCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.dispose();
            return null;
        }
    }

    private static class SetupSchemeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;
        private final boolean cleanupMode;

        SetupSchemeCallable(PhysicalStorage substorage, boolean cleanupMode) {
            this.substorage = substorage;
            this.cleanupMode = cleanupMode;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.setupScheme(this.cleanupMode);
            return null;
        }
    }
}

