/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ReplicationPhysicalStorageConfiguration
implements XSerializable {
    private String uid;
    private final Map<String, SubstorageConfiguration> substorageConfigurations = new HashMap<String, SubstorageConfiguration>();

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public Map<String, SubstorageConfiguration> getStorageConfigs() {
        return this.substorageConfigurations;
    }

    public void toXML(Element elm) throws Exception {
        elm.setAttribute("uid", this.uid);
        for (Map.Entry<String, SubstorageConfiguration> entry : this.substorageConfigurations.entrySet()) {
            Element physicalStorageElm = XmlUtil.addElement((Element)elm, (String)"physicalStorage");
            physicalStorageElm.setAttribute("className", entry.getValue().className);
            physicalStorageElm.setAttribute("read", Boolean.toString(entry.getValue().read));
            XHelper.writeObject((Element)physicalStorageElm, (String)"configuration", (Object)entry.getValue().configuration);
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.uid = elm.getAttribute("uid");
        for (Element physicalStorageElm : XmlUtil.getElements((Element)elm, (String)"physicalStorage")) {
            SubstorageConfiguration config = new SubstorageConfiguration();
            config.className = physicalStorageElm.getAttribute("className");
            config.read = Boolean.parseBoolean(physicalStorageElm.getAttribute("read"));
            config.configuration = (XSerializable)XHelper.readObject((Element)physicalStorageElm, (String)"configuration");
            this.substorageConfigurations.put(UUIDGenerator.generate().toString(), config);
        }
    }

    public static final class SubstorageConfiguration {
        public String className;
        public XSerializable configuration;
        public boolean read;
    }
}

