/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication;

import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationPhysicalStorageSession
implements PhysicalStorageSession {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final PhysicalStorage boundSubstorage;
    final PhysicalStorageSession boundSubsession;
    final ReplicationPhysicalStorage replicationStorage;
    final List<PhysicalStorageOperation> operations = new ArrayList<PhysicalStorageOperation>();
    final Map<String, Object> context;

    public ReplicationPhysicalStorageSession(PhysicalStorage boundSubstorage, PhysicalStorageSession boundSubsession, ReplicationPhysicalStorage replicationStorage, Map<String, Object> context) {
        this.boundSubstorage = boundSubstorage;
        this.boundSubsession = boundSubsession;
        this.replicationStorage = replicationStorage;
        this.context = context;
    }

    public PhysicalStorage getBoundSubstorage() {
        return this.boundSubstorage;
    }

    public PhysicalStorageSession getBoundSubsession() {
        return this.boundSubsession;
    }

    public ReplicationPhysicalStorage getReplicationStorage() {
        return this.replicationStorage;
    }

    public void addOperation(PhysicalStorageOperation operation) {
        this.operations.add(operation);
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public void begin() throws Exception {
        this.operations.clear();
        this.boundSubsession.begin();
    }

    @Override
    public boolean isOpen() {
        return this.boundSubsession.isOpen();
    }

    @Override
    public void commit() throws Exception {
        ArrayList<CommitCallable> commits = new ArrayList<CommitCallable>(this.replicationStorage.getSubstorageCount());
        for (int i = 0; i < this.replicationStorage.getSubstorageCount(); ++i) {
            commits.add(new CommitCallable(i, LogicalStorage.get().getUser()));
        }
        List futures = this.replicationStorage.getExecutorService().invokeAll(commits);
        HashMap<Integer, Boolean> success = new HashMap<Integer, Boolean>();
        Throwable error = null;
        for (int i = 0; i < futures.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                success.put(i, Boolean.TRUE);
                continue;
            }
            catch (Throwable t) {
                success.put(i, Boolean.FALSE);
                if (error != null) continue;
                error = t;
            }
        }
        if (error != null) {
            ArrayList<RestoreCallable> restores = new ArrayList<RestoreCallable>();
            for (Map.Entry entry : success.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                restores.add(new RestoreCallable((Integer)entry.getKey(), LogicalStorage.get().getUser()));
            }
            this.replicationStorage.getExecutorService().invokeAll(restores);
            throw new Exception("commit failed", error);
        }
    }

    @Override
    public void rollback() throws Exception {
        this.operations.clear();
        this.boundSubsession.rollback();
    }

    @Override
    public void close() throws Exception {
        this.operations.clear();
        this.boundSubsession.close();
    }

    private class RestoreCallable
    implements Callable<Object> {
        private final Logger restoreLog = LoggerFactory.getLogger((String)String.format("%s.%s", ReplicationPhysicalStorageSession.class.getName(), "RESTORE"));
        private final int idx;
        private final String user;

        RestoreCallable(int idx, String user) {
            this.idx = idx;
            this.user = user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            PhysicalStorage substorage = ReplicationPhysicalStorageSession.this.replicationStorage.getSubstorages().get(this.idx);
            this.restoreLog.debug(String.format("|substorage=%s| BEGIN restore", substorage.getUid()));
            LogicalStorage.get().setUser(this.user);
            this.restoreLog.debug(String.format("|substorage=%s| set user %s", substorage.getUid(), this.user));
            try {
                PhysicalStorageSession subsession = substorage.createSession(ReplicationPhysicalStorageSession.this.context);
                try {
                    this.restoreLog.debug(String.format("|substorage=%s| subsession created", substorage.getUid()));
                    subsession.begin();
                    this.restoreLog.debug(String.format("|substorage=%s| subsession opened", substorage.getUid()));
                    try {
                        int operationsSize = ReplicationPhysicalStorageSession.this.operations.size();
                        for (int i = operationsSize - 1; i >= 0; --i) {
                            PhysicalStorageOperation operation = ReplicationPhysicalStorageSession.this.operations.get(i);
                            operation.restore(substorage, subsession);
                            this.restoreLog.debug(String.format("|substorage=%s| operation restored (%d of %d) // %s", substorage.getUid(), i + 1, operationsSize, operation.toString()));
                        }
                        subsession.commit();
                        this.restoreLog.debug(String.format("|substorage=%s| subsession commit succeeded", substorage.getUid()));
                    }
                    catch (Throwable t) {
                        this.restoreLog.error(String.format("|substorage=%s| subsession commit failed", substorage.getUid()), t);
                        subsession.rollback();
                        this.restoreLog.debug(String.format("|substorage=%s| subsession rollback succeeded", substorage.getUid()));
                        throw new Exception("failed", t);
                    }
                }
                catch (Throwable throwable) {
                    subsession.close();
                    this.restoreLog.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
                    throw throwable;
                }
                subsession.close();
                this.restoreLog.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
            }
            catch (Throwable throwable) {
                this.restoreLog.debug(String.format("|substorage=%s| END restore", substorage.getUid()));
                throw throwable;
            }
            this.restoreLog.debug(String.format("|substorage=%s| END restore", substorage.getUid()));
            return null;
        }
    }

    private class CommitCallable
    implements Callable<Object> {
        private final int idx;
        private final String user;

        CommitCallable(int idx, String user) {
            this.idx = idx;
            this.user = user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            PhysicalStorage substorage;
            block10: {
                substorage = ReplicationPhysicalStorageSession.this.replicationStorage.getSubstorages().get(this.idx);
                ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| BEGIN commit", substorage.getUid()));
                LogicalStorage.get().setUser(this.user);
                ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| set user %s", substorage.getUid(), this.user));
                try {
                    if (substorage == ReplicationPhysicalStorageSession.this.boundSubstorage) {
                        ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| substorage is the bound one", substorage.getUid()));
                        try {
                            ReplicationPhysicalStorageSession.this.boundSubsession.commit();
                            ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| bound subsession commit succeeded", substorage.getUid()));
                            break block10;
                        }
                        catch (Throwable t) {
                            ReplicationPhysicalStorageSession.this.log.error(String.format("|substorage=%s| bound subsession commit failed", substorage.getUid()), t);
                            ReplicationPhysicalStorageSession.this.boundSubsession.rollback();
                            ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| bound subsession rollback succeeded", substorage.getUid()));
                            throw new Exception("failed", t);
                        }
                    }
                    PhysicalStorageSession subsession = substorage.createSession(ReplicationPhysicalStorageSession.this.context);
                    try {
                        ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession created", substorage.getUid()));
                        subsession.begin();
                        ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession opened", substorage.getUid()));
                        try {
                            int operationsSize = ReplicationPhysicalStorageSession.this.operations.size();
                            for (int i = 0; i < operationsSize; ++i) {
                                PhysicalStorageOperation operation = ReplicationPhysicalStorageSession.this.operations.get(i);
                                operation.execute(substorage, subsession);
                                ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| operation executed (%d of %d) // %s", substorage.getUid(), i + 1, operationsSize, operation.toString()));
                            }
                            subsession.commit();
                            ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession commit succeeded", substorage.getUid()));
                        }
                        catch (Throwable t) {
                            ReplicationPhysicalStorageSession.this.log.error(String.format("|substorage=%s| subsession commit failed", substorage.getUid()), t);
                            subsession.rollback();
                            ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession rollback succeeded", substorage.getUid()));
                            throw new Exception("failed", t);
                        }
                    }
                    catch (Throwable throwable) {
                        subsession.close();
                        ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
                        throw throwable;
                    }
                    subsession.close();
                    ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| subsession closed", substorage.getUid()));
                }
                catch (Throwable throwable) {
                    ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| END commit", substorage.getUid()));
                    throw throwable;
                }
            }
            ReplicationPhysicalStorageSession.this.log.debug(String.format("|substorage=%s| END commit", substorage.getUid()));
            return null;
        }
    }
}

