/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.archive;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageDeleteAssetOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageSaveAssetOperation;
import java.util.Date;
import java.util.List;

class ArchiveAssetStorage
implements AssetPhysicalStorage {
    private final ArchivePhysicalStorage storage;

    public ArchiveAssetStorage(ArchivePhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getAssetStorage().searchAssets(cls, query, castedSession.getSubsession(cls));
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getAssetStorage().searchAssets(cls, query, castedSession.getSubsession(cls));
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new AssetStorageSaveAssetOperation<A>(asset, restoreData), this.storage, session, asset.getAsset().getClass());
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new AssetStorageDeleteAssetOperation<A>(asset), this.storage, session, asset.getAsset().getClass());
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getAssetStorage().loadAsset(cls, uid, castedSession.getSubsession(cls));
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getAssetStorage().getAssetUids(cls, startDate, endDate, sortOrder, limit, castedSession.getSubsession(cls));
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getAssetStorage().isAssetExist(cls, uid, castedSession);
    }
}

