/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.archive;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageDeleteDataOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageUpdateDataOperation;
import java.util.ArrayList;
import java.util.List;

class ArchiveBulkDictionaryStorage
implements BulkDictionaryPhysicalStorage {
    private final ArchivePhysicalStorage storage;

    public ArchiveBulkDictionaryStorage(ArchivePhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        List<PhysicalBulkDictionaryMetadata<?>> mainResult = this.storage.getMainSubstorage().getBulkDictionaryStorage().loadMetadata(castedSession.getMainSession());
        List<PhysicalBulkDictionaryMetadata<?>> archiveResult = this.storage.getArchiveSubstorage().getBulkDictionaryStorage().loadMetadata(castedSession.getArchiveSession());
        if (mainResult == null && archiveResult == null) {
            return null;
        }
        ArrayList result = new ArrayList((mainResult == null ? 0 : mainResult.size()) + (archiveResult == null ? 0 : archiveResult.size()));
        if (mainResult != null) {
            result.addAll(mainResult);
        }
        if (archiveResult != null) {
            result.addAll(archiveResult);
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(key).getBulkDictionaryStorage().loadData(key, castedSession.getSubsession(key));
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new BulkDictionaryStorageUpdateDataOperation<D>(data, restoreData), this.storage, session, data.getDictionaryType());
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new BulkDictionaryStorageDeleteDataOperation<D>(data), this.storage, session, data.getDictionaryType());
    }
}

