/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.archive;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteAllOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageSaveDictionaryOperation;
import java.util.Date;
import java.util.List;
import java.util.Set;

class ArchiveDictionaryStorage
implements DictionaryPhysicalStorage {
    private final ArchivePhysicalStorage storage;

    public ArchiveDictionaryStorage(ArchivePhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getDictionaryStorage().findDictionaryByCode(cls, code, deleted, castedSession.getSubsession(cls));
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, castedSession.getSubsession(cls));
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageDeleteDictionaryOperation<D>(data), this.storage, session, data.getDictionaryType());
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageSaveDictionaryOperation<D>(data, oldData), this.storage, session, data.getDictionaryType());
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSynce, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(dictClass).getDictionaryStorage().loadAll(modifiedSynce, deleted, dictClass, ignoredTypes, castedSession.getSubsession(dictClass));
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getDictionaryStorage().getDictionaryUids(cls, startDate, endDate, useCreateDate, ignoreDeleted, sortOrder, limit, castedSession.getSubsession(cls));
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageDeleteAllOperation(cls), this.storage, session, cls);
    }
}

