/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.archive;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllEntitiesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteVersionOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveIndexesOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class ArchiveEntityStorage
implements EntityPhysicalStorage {
    private final ArchivePhysicalStorage storage;

    public ArchiveEntityStorage(ArchivePhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().searchEntity(cls, query, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().searchEntity(cls, query, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().loadEntity(cls, uid, versionNumber, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, int ... versionNumbers) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(entityData.getEntityType()).getEntityStorage().getVersions(entityData, castedSession.getSubsession(entityData.getEntityType()), versionNumbers);
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> ref, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(ref.getType()).getEntityStorage().getVersionsMetadata(ref, castedSession.getSubsession(ref.getType()));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> cls, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteIndexesOperation(cls, containerUid, restoreData), this.storage, session, cls);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> cls, Map<EntityPhysicalStorage, List<D>> indexes, String containerUid, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageSaveIndexesOperation(cls, indexes, containerUid), this.storage, session, cls);
    }

    @Override
    public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageSaveEntityOperation<E>(etc, restoreData), this.storage, session, etc.getEntityType());
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteEntityOperation<E>(data), this.storage, session, data.getEntityType());
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteVersionOperation<E>(data, versionNumber, restoreData), this.storage, session, data.getEntityType());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(indexClass).getEntityStorage().getIndexes(indexClass, uid, castedSession.getSubsession(indexClass));
    }

    @Override
    public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        ArrayList mainTypes = new ArrayList();
        ArrayList archiveTypes = new ArrayList();
        for (Class<?> clazz : types) {
            (this.storage.isArchived(clazz) ? archiveTypes : mainTypes).add(clazz);
        }
        ArrayList<PhysicalEntityDataModification> result = new ArrayList<PhysicalEntityDataModification>();
        if (!mainTypes.isEmpty()) {
            result.addAll(this.storage.getMainSubstorage().getEntityStorage().getEntityModifications(mainTypes, timeStampFrom, timeStampTo, castedSession.getMainSession()));
        }
        if (!archiveTypes.isEmpty()) {
            result.addAll(this.storage.getArchiveSubstorage().getEntityStorage().getEntityModifications(archiveTypes, timeStampFrom, timeStampTo, castedSession.getArchiveSession()));
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().isEntityAvailable(cls, uid, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().isEntityExist(cls, uid, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        ArchivePhysicalStorageSession castedSession = (ArchivePhysicalStorageSession)session;
        return this.storage.getSubstorage(cls).getEntityStorage().getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, castedSession.getSubsession(cls));
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteAllEntitiesOperation(cls), this.storage, session, cls);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteAllIndexesOperation(cls), this.storage, session, cls);
    }
}

