/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.archive;

import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.archive.ArchivePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivePhysicalStorageSession
implements PhysicalStorageSession {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PhysicalStorageSession mainSession;
    private final PhysicalStorageSession archiveSession;
    final ArchivePhysicalStorage archiveStorage;
    private final List<PhysicalStorageOperation> mainOperations = new ArrayList<PhysicalStorageOperation>();
    private final List<PhysicalStorageOperation> archiveOperations = new ArrayList<PhysicalStorageOperation>();
    final Map<String, Object> context;

    public ArchivePhysicalStorageSession(PhysicalStorageSession mainSession, PhysicalStorageSession archiveSession, ArchivePhysicalStorage archiveStorage, Map<String, Object> context) {
        this.mainSession = mainSession;
        this.archiveSession = archiveSession;
        this.archiveStorage = archiveStorage;
        this.context = context;
    }

    public PhysicalStorageSession getMainSession() {
        return this.mainSession;
    }

    public PhysicalStorageSession getArchiveSession() {
        return this.archiveSession;
    }

    public PhysicalStorageSession getSubsession(Class<?> clazz) {
        return this.archiveStorage.isArchived(clazz) ? this.archiveSession : this.mainSession;
    }

    public void addOperation(PhysicalStorageOperation operation, Class<?> clazz) {
        (this.archiveStorage.isArchived(clazz) ? this.archiveOperations : this.mainOperations).add(operation);
    }

    @Override
    public void begin() throws Exception {
        this.mainOperations.clear();
        this.archiveOperations.clear();
        ArrayList<BeginCallable> tasks = new ArrayList<BeginCallable>(2);
        tasks.add(new BeginCallable(this.mainSession));
        tasks.add(new BeginCallable(this.archiveSession));
        List futures = this.archiveStorage.getExecutorService().invokeAll(tasks);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(2);
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("begin succeeded for main session");
        }
        catch (Throwable t) {
            exceptions.add(t);
            this.log.warn("begin failed for main session", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("begin succeeded for archive session");
        }
        catch (Throwable t) {
            exceptions.add(t);
            this.log.warn("begin failed for archive session", t);
        }
        if (!exceptions.isEmpty()) {
            throw new MultiException(exceptions);
        }
    }

    @Override
    public boolean isOpen() {
        return this.mainSession.isOpen() || this.archiveSession.isOpen();
    }

    @Override
    public void commit() throws Exception {
        Throwable error;
        boolean archiveSuccess;
        boolean mainSuccess;
        block8: {
            ArrayList<CommitCallable> commits = new ArrayList<CommitCallable>(2);
            commits.add(new CommitCallable(this.mainSession, "main", LogicalStorage.get().getUser()));
            commits.add(new CommitCallable(this.archiveSession, "archive", LogicalStorage.get().getUser()));
            List futures = this.archiveStorage.getExecutorService().invokeAll(commits);
            mainSuccess = true;
            archiveSuccess = true;
            error = null;
            try {
                ((Future)futures.get(0)).get();
            }
            catch (Throwable t) {
                mainSuccess = false;
                error = t;
            }
            try {
                ((Future)futures.get(1)).get();
            }
            catch (Throwable t) {
                archiveSuccess = false;
                if (error != null) break block8;
                error = t;
            }
        }
        if (error != null) {
            ArrayList<RestoreCallable> restores = new ArrayList<RestoreCallable>();
            if (mainSuccess) {
                restores.add(new RestoreCallable(this.archiveStorage.getMainSubstorage(), "main", LogicalStorage.get().getUser(), this.mainOperations));
            }
            if (archiveSuccess) {
                restores.add(new RestoreCallable(this.archiveStorage.getArchiveSubstorage(), "archive", LogicalStorage.get().getUser(), this.archiveOperations));
            }
            if (restores.size() > 0) {
                this.archiveStorage.getExecutorService().invokeAll(restores);
            }
            throw new Exception("commit failed", error);
        }
    }

    @Override
    public void rollback() throws Exception {
        ArrayList<RollbackCallable> tasks = new ArrayList<RollbackCallable>(2);
        tasks.add(new RollbackCallable(this.mainSession));
        tasks.add(new RollbackCallable(this.archiveSession));
        List futures = this.archiveStorage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("rollback succeeded for main session");
        }
        catch (Throwable t) {
            success = false;
            this.log.warn("rollback failed for main session", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("rollback succeeded for archive session");
        }
        catch (Throwable t) {
            success = false;
            this.log.warn("rollback failed for archive session", t);
        }
        if (!success) {
            throw new Exception("rollback failed");
        }
    }

    @Override
    public void close() throws Exception {
        ArrayList<CloseCallable> tasks = new ArrayList<CloseCallable>(2);
        ArrayList<String> openSessions = new ArrayList<String>();
        if (this.mainSession.isOpen()) {
            tasks.add(new CloseCallable(this.mainSession));
            openSessions.add("main");
        } else {
            this.log.debug("main session is already closed");
        }
        if (this.archiveSession.isOpen()) {
            tasks.add(new CloseCallable(this.archiveSession));
            openSessions.add("archive");
        } else {
            this.log.debug("archive session is already closed");
        }
        List futures = this.archiveStorage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < openSessions.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("close succeeded for %s session", openSessions.get(i)));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.warn(String.format("close failed for %s session", openSessions.get(i)), t);
            }
        }
        if (!success) {
            throw new Exception("begin failed");
        }
    }

    private static class CloseCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        CloseCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.close();
            return null;
        }
    }

    private static class RollbackCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        RollbackCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.rollback();
            return null;
        }
    }

    private class RestoreCallable
    implements Callable<Object> {
        private final Logger restoreLog = LoggerFactory.getLogger((String)String.format("%s.%s", ArchivePhysicalStorageSession.class.getName(), "RESTORE"));
        private final PhysicalStorage storage;
        private final String id;
        private final String user;
        private final List<PhysicalStorageOperation> operations = new ArrayList<PhysicalStorageOperation>();

        RestoreCallable(PhysicalStorage storage, String id, String user, List<PhysicalStorageOperation> operations) {
            this.storage = storage;
            this.id = id;
            this.user = user;
            this.operations.addAll(operations);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            this.restoreLog.debug(String.format("|%s| BEGIN restore", this.id));
            LogicalStorage.get().setUser(this.user);
            this.restoreLog.debug(String.format("|%s| set user %s", this.id, this.user));
            try {
                PhysicalStorageSession session = null;
                try {
                    session = this.storage.createSession(ArchivePhysicalStorageSession.this.context);
                }
                catch (Exception e) {
                    this.restoreLog.warn("unable to create session", (Throwable)e);
                    throw e;
                }
                try {
                    this.restoreLog.debug(String.format("|%s| rollback session created", this.id));
                    session.begin();
                    this.restoreLog.debug(String.format("|%s| rollback session opened", this.id));
                    try {
                        int operationsSize = this.operations.size();
                        for (int i = operationsSize - 1; i >= 0; --i) {
                            PhysicalStorageOperation operation = this.operations.get(i);
                            operation.restore(this.storage, session);
                            this.restoreLog.debug(String.format("|%s| operation restored (%d of %d) // %s", this.id, i + 1, operationsSize, operation.toString()));
                        }
                        session.commit();
                        this.restoreLog.debug(String.format("|%s| rollback session commit succeeded", this.id));
                    }
                    catch (Throwable t) {
                        this.restoreLog.warn(String.format("|%s| rollback session commit failed", this.id), t);
                        session.rollback();
                        this.restoreLog.debug(String.format("|%s| rollback session rollback succeeded", this.id));
                        throw new Exception("failed", t);
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    this.restoreLog.debug(String.format("|%s| rollback session closed", this.id));
                    throw throwable;
                }
                session.close();
                this.restoreLog.debug(String.format("|%s| rollback session closed", this.id));
            }
            catch (Throwable throwable) {
                this.restoreLog.debug(String.format("|%s| END restore", this.id));
                throw throwable;
            }
            this.restoreLog.debug(String.format("|%s| END restore", this.id));
            return null;
        }
    }

    private class CommitCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;
        private final String id;
        private final String user;

        CommitCallable(PhysicalStorageSession session, String id, String user) {
            this.session = session;
            this.id = id;
            this.user = user;
        }

        @Override
        public Object call() throws Exception {
            ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| BEGIN commit", this.id));
            try {
                LogicalStorage.get().setUser(this.user);
                ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| set user %s", this.id, this.user));
                try {
                    this.session.commit();
                    ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| session commit succeeded", this.id));
                }
                catch (Throwable t) {
                    ArchivePhysicalStorageSession.this.log.warn(String.format("|%s| session commit failed", this.id), t);
                    this.session.rollback();
                    ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| session rollback succeeded", this.id));
                    throw new Exception("failed", t);
                }
            }
            catch (Throwable throwable) {
                ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| END commit", this.id));
                throw throwable;
            }
            ArchivePhysicalStorageSession.this.log.debug(String.format("|%s| END commit", this.id));
            return null;
        }
    }

    private static class BeginCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        BeginCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.begin();
            return null;
        }
    }
}

