/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.cached.MonitoringUtil;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageDeleteAssetOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageSaveAssetOperation;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedAssetStorage
implements AssetPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CachedPhysicalStorage storage;

    public CachedAssetStorage(CachedPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getAssetStorage().searchAssets(cls, query, castedSession.getMainSession());
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getAssetStorage().searchAssets(cls, query, castedSession.getMainSession());
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new AssetStorageSaveAssetOperation<A>(asset, restoreData), this.storage, session, this.log);
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new AssetStorageDeleteAssetOperation<A>(asset), this.storage, session, this.log);
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        PhysicalAssetData<A> result = null;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getAssetStorage().loadAsset(cls, uid, castedSession.getCacheSession())) != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ASSET, "loadAsset", cls, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getAssetStorage().loadAsset(cls, uid, castedSession.getMainSession());
        if (result != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ASSET, "loadAsset", cls, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getAssetStorage().getAssetUids(cls, startDate, endDate, sortOrder, limit, castedSession.getMainSession());
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getAssetStorage().isAssetExist(cls, uid, castedSession);
    }
}

