/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.cached.MonitoringUtil;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageDeleteDataOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageUpdateDataOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedBulkDictionaryStorage
implements BulkDictionaryPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CachedPhysicalStorage storage;

    public CachedBulkDictionaryStorage(CachedPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getBulkDictionaryStorage().loadMetadata(castedSession.getMainSession());
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        PhysicalBulkDictionaryData<D> result = null;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getBulkDictionaryStorage().loadData(key, castedSession.getCacheSession())) != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.BULK_DICTIONARY, "loadData", key, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getBulkDictionaryStorage().loadData(key, castedSession.getMainSession());
        if (result != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.BULK_DICTIONARY, "loadData", key, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new BulkDictionaryStorageUpdateDataOperation<D>(data, restoreData), this.storage, session, this.log);
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new BulkDictionaryStorageDeleteDataOperation<D>(data), this.storage, session, this.log);
    }
}

