/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.MonitoringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedDBPropertiesStorage
implements DBPropertiesPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final CachedPhysicalStorage storage;

    public CachedDBPropertiesStorage(CachedPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public void putDbProperty(String key, String value, String oldValue) throws Exception {
        ArrayList<PutDBPropertyCallable> tasks = new ArrayList<PutDBPropertyCallable>(2);
        tasks.add(new PutDBPropertyCallable(this.storage.getMainSubstorage().getDBPropertiesStorage(), key, value, oldValue));
        tasks.add(new PutDBPropertyCallable(this.storage.getCacheSubstorage().getDBPropertiesStorage(), key, value, oldValue));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean mainSuccess = true;
        boolean cacheSuccess = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("putDbProperty succeeded for main substorage");
        }
        catch (Throwable t) {
            this.log.error("putDbProperty failed for main substorage", t);
            mainSuccess = false;
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("putDbProperty succeeded for cache substorage");
        }
        catch (Throwable t) {
            this.log.error("putDbProperty failed for cache substorage", t);
            cacheSuccess = false;
        }
        if (!mainSuccess || !cacheSuccess) {
            this.log.error("putDbProperty failed, restoring values");
            try {
                (mainSuccess ? this.storage.getMainSubstorage() : this.storage.getCacheSubstorage()).getDBPropertiesStorage().putDbProperty(key, oldValue, value);
            }
            catch (Throwable t) {
                this.log.error(String.format("failed to restore value in %s substorage", mainSuccess ? "main" : "cache"), t);
            }
            throw new Exception("putDbProperty failed");
        }
    }

    @Override
    public String getDbProperty(String key) throws Exception {
        long startTime = System.currentTimeMillis();
        String result = null;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getDBPropertiesStorage().getDbProperty(key)) != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.DB_PROPERTIES, "getDbProperty", NamedValue.class, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getDBPropertiesStorage().getDbProperty(key);
        if (result != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.DB_PROPERTIES, "getDbProperty", NamedValue.class, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public Map<String, String> getAllKeys() throws Exception {
        return this.storage.getMainSubstorage().getDBPropertiesStorage().getAllKeys();
    }

    private class PutDBPropertyCallable
    implements Callable<Object> {
        private final DBPropertiesPhysicalStorage substorage;
        private final String key;
        private final String value;
        private final String oldValue;

        PutDBPropertyCallable(DBPropertiesPhysicalStorage substorage, String key, String value, String oldValue) {
            this.substorage = substorage;
            this.key = key;
            this.value = value;
            this.oldValue = oldValue;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.putDbProperty(this.key, this.value, this.oldValue);
            return null;
        }
    }
}

