/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.cached.MonitoringUtil;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteAllOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageSaveDictionaryOperation;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedDictionaryStorage
implements DictionaryPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CachedPhysicalStorage storage;

    public CachedDictionaryStorage(CachedPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getDictionaryStorage().findDictionaryByCode(cls, code, deleted, castedSession.getMainSession());
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        PhysicalDictionaryData<D> result = null;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, castedSession.getCacheSession())) != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.DICTIONARY, "findDictionaryByUid", cls, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, castedSession.getMainSession());
        if (result != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.DICTIONARY, "findDictionaryByUid", cls, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageDeleteDictionaryOperation<D>(data), this.storage, session, this.log);
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageSaveDictionaryOperation<D>(data, oldData), this.storage, session, this.log);
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSynce, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getDictionaryStorage().loadAll(modifiedSynce, deleted, dictClass, ignoredTypes, castedSession.getMainSession());
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getDictionaryStorage().getDictionaryUids(cls, startDate, endDate, useCreateDate, ignoreDeleted, sortOrder, limit, castedSession.getMainSession());
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new DictionaryStorageDeleteAllOperation(cls), this.storage, session, this.log);
    }
}

