/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.InvocationHelper;
import com.gridnine.xtrip.server.db.storage.replication.cached.MonitoringUtil;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllEntitiesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteVersionOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveIndexesOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedEntityStorage
implements EntityPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CachedPhysicalStorage storage;

    public CachedEntityStorage(CachedPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().searchEntity(cls, query, castedSession.getMainSession());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().searchEntity(cls, query, castedSession.getMainSession());
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        PhysicalEntityData<E> result = null;
        if (!this.storage.isCacheWriteOnly()) {
            try {
                result = this.storage.getCacheSubstorage().getEntityStorage().loadEntity(cls, uid, versionNumber, castedSession.getCacheSession());
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
            if (result != null) {
                MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "loadEntity", cls, MonitoringUtil.Substorage.CACHE, startTime);
                return result;
            }
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getEntityStorage().loadEntity(cls, uid, versionNumber, castedSession.getMainSession());
        if (result != null) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "loadEntity", cls, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, int ... versionNumbers) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        List<PhysicalVersionData> result = null;
        long startTime = System.currentTimeMillis();
        if (!this.storage.isCacheWriteOnly() && versionNumbers != null && versionNumbers.length == 1) {
            try {
                result = this.storage.getCacheSubstorage().getEntityStorage().getVersions(entityData, castedSession.getCacheSession(), versionNumbers);
            }
            catch (IllegalArgumentException ex) {
                result = null;
            }
        }
        if (result != null && !result.isEmpty()) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "getVersions", entityData.getEntityType(), MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getEntityStorage().getVersions(entityData, castedSession.getMainSession(), versionNumbers);
        if (result != null && !result.isEmpty()) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "getVersions", entityData.getEntityType(), MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> ref, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().getVersionsMetadata(ref, castedSession.getMainSession());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> cls, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteIndexesOperation(cls, containerUid, restoreData), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> cls, Map<EntityPhysicalStorage, List<D>> indexes, String containerUid, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageSaveIndexesOperation(cls, indexes, containerUid), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageSaveEntityOperation<E>(etc, restoreData), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteEntityOperation<E>(data), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteVersionOperation<E>(data, versionNumber, restoreData), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().getIndexes(indexClass, uid, castedSession.getMainSession());
    }

    @Override
    public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().getEntityModifications(types, timeStampFrom, timeStampTo, castedSession.getMainSession());
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        boolean result = false;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getEntityStorage().isEntityAvailable(cls, uid, castedSession.getCacheSession()))) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "isEntityAvailable", cls, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getEntityStorage().isEntityAvailable(cls, uid, castedSession.getMainSession());
        if (result) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "isEntityAvailable", cls, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        long startTime = System.currentTimeMillis();
        boolean result = false;
        if (!this.storage.isCacheWriteOnly() && (result = this.storage.getCacheSubstorage().getEntityStorage().isEntityExist(cls, uid, castedSession.getCacheSession()))) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "isEntityExists", cls, MonitoringUtil.Substorage.CACHE, startTime);
            return result;
        }
        startTime = System.currentTimeMillis();
        result = this.storage.getMainSubstorage().getEntityStorage().isEntityExist(cls, uid, castedSession.getMainSession());
        if (result) {
            MonitoringUtil.statForMonitoringData(MonitoringUtil.StorageType.ENTITY, "isEntityExists", cls, MonitoringUtil.Substorage.MAIN, startTime);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        CachedPhysicalStorageSession castedSession = (CachedPhysicalStorageSession)session;
        return this.storage.getMainSubstorage().getEntityStorage().getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, castedSession.getMainSession());
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteAllEntitiesOperation(cls), this.storage, session, this.log);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
        InvocationHelper.invoke(new EntityStorageDeleteAllIndexesOperation(cls), this.storage, session, this.log);
    }
}

