/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.cached;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedAssetStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedDBPropertiesStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedEntityStorage;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.cached.CachedPhysicalStorageSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPhysicalStorage
implements PhysicalStorage {
    private final boolean cacheWriteOnly;
    private final PhysicalStorage mainSubstorage;
    private final PhysicalStorage cacheSubstorage;
    private final ExecutorServiceFacade executorService;
    private final CachedEntityStorage entityStorage;
    private final CachedDictionaryStorage dictionaryStorage;
    private final CachedBulkDictionaryStorage bulkDictionaryStorage;
    private final CachedAssetStorage assetStorage;
    private final CachedDBPropertiesStorage dbPropertiesStorage;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String uid;

    public CachedPhysicalStorage(CachedPhysicalStorageConfiguration configuration) throws Exception {
        this.log.debug("initializing...");
        this.uid = configuration.getUid();
        this.cacheWriteOnly = configuration.isCacheWriteOnly();
        this.log.debug("creating substorages...");
        this.mainSubstorage = (PhysicalStorage)Class.forName(configuration.getMainStorageClassName()).getConstructor(configuration.getMainStorageConfiguration().getClass()).newInstance(configuration.getMainStorageConfiguration());
        LogicalStorageRegistry.get().registerPhysicalStorage(this.mainSubstorage);
        this.log.debug(String.format("created main substorage %s", this.mainSubstorage.getUid()));
        this.cacheSubstorage = (PhysicalStorage)Class.forName(configuration.getCacheStorageClassName()).getConstructor(configuration.getCacheStorageConfiguration().getClass()).newInstance(configuration.getCacheStorageConfiguration());
        LogicalStorageRegistry.get().registerPhysicalStorage(this.cacheSubstorage);
        this.log.debug(String.format("created cache substorage %s", this.cacheSubstorage.getUid()));
        this.log.debug("creating executor service...");
        this.executorService = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newCachedThreadPool("cached-physical-storage");
        this.log.debug("creating entity storage...");
        this.entityStorage = new CachedEntityStorage(this);
        this.log.debug("creating dictionary storage...");
        this.dictionaryStorage = new CachedDictionaryStorage(this);
        this.log.debug("creating bulk dictionary storage...");
        this.bulkDictionaryStorage = new CachedBulkDictionaryStorage(this);
        this.log.debug("creating asset storage...");
        this.assetStorage = new CachedAssetStorage(this);
        this.log.debug("creating db properties storage...");
        this.dbPropertiesStorage = new CachedDBPropertiesStorage(this);
        this.log.debug("initialized");
    }

    public boolean isCacheWriteOnly() {
        return this.cacheWriteOnly;
    }

    public PhysicalStorage getMainSubstorage() {
        return this.mainSubstorage;
    }

    public PhysicalStorage getCacheSubstorage() {
        return this.cacheSubstorage;
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        ArrayList<CreateSessionCallable> tasks = new ArrayList<CreateSessionCallable>(2);
        tasks.add(new CreateSessionCallable(this.mainSubstorage, context));
        tasks.add(new CreateSessionCallable(this.cacheSubstorage, context));
        List futures = this.executorService.invokeAll(tasks);
        PhysicalStorageSession mainSession = null;
        PhysicalStorageSession cacheSession = null;
        boolean success = true;
        try {
            mainSession = (PhysicalStorageSession)((Future)futures.get(0)).get();
            this.log.debug("createSession succeeded for main storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("createSession failed for main storage", t);
        }
        try {
            cacheSession = (PhysicalStorageSession)((Future)futures.get(1)).get();
            this.log.debug("createSession succeeded for cache storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("createSession failed for cache storage", t);
        }
        if (!success) {
            if (mainSession != null) {
                try {
                    mainSession.close();
                    this.log.debug("closeSession succeeded for main storage");
                }
                catch (Throwable t) {
                    this.log.error("closeSession failed for main storage", t);
                }
            }
            if (cacheSession != null) {
                try {
                    cacheSession.close();
                    this.log.debug("closeSession succeeded for cache storage");
                }
                catch (Throwable t) {
                    this.log.error("closeSession failed for cache storage", t);
                }
            }
            throw new Exception("createSession failed");
        }
        return new CachedPhysicalStorageSession(mainSession, cacheSession, this, context);
    }

    ExecutorServiceFacade getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        ArrayList<SetupSchemeCallable> tasks = new ArrayList<SetupSchemeCallable>(2);
        tasks.add(new SetupSchemeCallable(this.mainSubstorage, cleanupMode));
        tasks.add(new SetupSchemeCallable(this.cacheSubstorage, cleanupMode));
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("setupScheme succeeded for main substorage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("setupScheme failed for main substorage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("setupScheme succeeded for cache substorage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("setupScheme failed for cache substorage", t);
        }
        if (!success) {
            throw new Exception("setupScheme failed");
        }
    }

    @Override
    public boolean checkHealth() {
        boolean result = true;
        if (!this.mainSubstorage.checkHealth()) {
            this.log.error("checkHealth failed for main substorage");
            result = false;
        }
        if (!this.cacheSubstorage.checkHealth()) {
            this.log.error("checkHealth failed for cache substorage");
            result = false;
        }
        return result;
    }

    @Override
    public void dispose() {
        ArrayList<DisposeCallable> tasks = new ArrayList<DisposeCallable>(2);
        tasks.add(new DisposeCallable(this.mainSubstorage));
        tasks.add(new DisposeCallable(this.cacheSubstorage));
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (Throwable t) {
            this.log.error("failed disposing substorages", t);
        }
        this.executorService.dispose();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.dbPropertiesStorage;
    }

    @Override
    public void maintain() throws Exception {
        ArrayList<MaintainCallable> tasks = new ArrayList<MaintainCallable>(2);
        tasks.add(new MaintainCallable(this.mainSubstorage));
        tasks.add(new MaintainCallable(this.cacheSubstorage));
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("maintain succeeded for main substorage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("maintain failed for main substorage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("maintain succeeded for cache substorage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("maintain failed for cache substorage", t);
        }
        if (!success) {
            throw new Exception("maintain failed");
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    private static class MaintainCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        MaintainCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.maintain();
            return null;
        }
    }

    private static class DisposeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        DisposeCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.dispose();
            return null;
        }
    }

    private static class SetupSchemeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;
        private final boolean cleanupMode;

        SetupSchemeCallable(PhysicalStorage substorage, boolean cleanupMode) {
            this.substorage = substorage;
            this.cleanupMode = cleanupMode;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.setupScheme(this.cleanupMode);
            return null;
        }
    }

    private static class CreateSessionCallable
    implements Callable<PhysicalStorageSession> {
        private final PhysicalStorage storage;
        private final Map<String, Object> context;

        CreateSessionCallable(PhysicalStorage storage, Map<String, Object> context) {
            this.storage = storage;
            this.context = context;
        }

        @Override
        public PhysicalStorageSession call() throws Exception {
            return this.storage.createSession(this.context);
        }
    }
}

