/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueAssetBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueCreateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDeleteOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueUpdateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.AssetMasterPhysicalStorage;
import java.util.Date;
import java.util.List;

class KeyValueAssetMasterPhysicalStorage
implements AssetMasterPhysicalStorage {
    private final KeyValueMasterPhysicalStorage storage;

    KeyValueAssetMasterPhysicalStorage(KeyValueMasterPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueAssetBundleWrapper.buildKey(asset.getAsset().getClass(), asset.getAsset().getUid());
        KeyValueAssetBundleWrapper wrapper = new KeyValueAssetBundleWrapper();
        wrapper.setPad(asset);
        if (restoreData == null) {
            castedSession.addOperation(new KeyValueCreateOperation(this.storage.getDriver(), key, wrapper));
        } else {
            KeyValueAssetBundleWrapper restoreWrapper = new KeyValueAssetBundleWrapper();
            restoreWrapper.setPad(restoreData);
            castedSession.addOperation(new KeyValueUpdateOperation(this.storage.getDriver(), key, wrapper, restoreWrapper));
        }
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueAssetBundleWrapper.buildKey(asset.getAsset().getClass(), asset.getAsset().getUid());
        KeyValueAssetBundleWrapper restoreWrapper = new KeyValueAssetBundleWrapper();
        restoreWrapper.setPad(asset);
        castedSession.addOperation(new KeyValueDeleteOperation(this.storage.getDriver(), key, restoreWrapper));
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueAssetBundleWrapper.buildKey(cls, uid), null);
        if (bundle == null) {
            return null;
        }
        KeyValueAssetBundleWrapper wrapper = KeyValueAssetBundleWrapper.unwrap(bundle);
        return wrapper.getPad();
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        return this.storage.getDriver().has(KeyValueAssetBundleWrapper.buildKey(cls, uid));
    }
}

