/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XObjectInput;
import com.gridnine.xtrip.common.util.XObjectOutput;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyValueBulkDictionaryDataBundleWrapper
implements KeyValueBundleWrapper {
    private PhysicalBulkDictionaryData<? extends BaseDictionary> pbdd;

    static String buildKey(Class<? extends BaseDictionary> cls) {
        StringBuilder sb = new StringBuilder();
        sb.append(MiscUtil.getSimpleClassName(BulkDictionaryData.class));
        sb.append('_');
        sb.append(cls.getName());
        return sb.toString();
    }

    public PhysicalBulkDictionaryData<? extends BaseDictionary> getPbdd() {
        return this.pbdd;
    }

    public void setPbdd(PhysicalBulkDictionaryData<? extends BaseDictionary> pbdd) {
        this.pbdd = pbdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueBundle wrap() throws Exception {
        KeyValueBundle bundle = new KeyValueBundle();
        if (this.pbdd != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XObjectOutput xoos = new XObjectOutput((OutputStream)baos);){
                xoos.writeByteArray(this.pbdd.getData());
                xoos.writeClass(this.pbdd.getDictionaryType());
                xoos.writeDate(this.pbdd.getModified());
            }
            bundle.setMetadata(baos.toByteArray());
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyValueBulkDictionaryDataBundleWrapper unwrap(KeyValueBundle bundle) throws Exception {
        KeyValueBulkDictionaryDataBundleWrapper wrapper = new KeyValueBulkDictionaryDataBundleWrapper();
        if (bundle.getMetadata() != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bundle.getMetadata());
                 XObjectInput xois = new XObjectInput((InputStream)bais);){
                PhysicalBulkDictionaryData pbdd = new PhysicalBulkDictionaryData();
                pbdd.setData(xois.readByteArray());
                pbdd.setDictionaryType(xois.readClass());
                pbdd.setModified(xois.readDate());
                wrapper.setPbdd(pbdd);
            }
        }
        return wrapper;
    }
}

