/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBulkDictionaryDataBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueCreateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDeleteOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueUpdateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BulkDictionaryMasterPhysicalStorage;

class KeyValueBulkDictionaryMasterPhysicalStorage
implements BulkDictionaryMasterPhysicalStorage {
    private final KeyValueMasterPhysicalStorage storage;

    KeyValueBulkDictionaryMasterPhysicalStorage(KeyValueMasterPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueBulkDictionaryDataBundleWrapper.buildKey(data.getDictionaryType());
        KeyValueBulkDictionaryDataBundleWrapper wrapper = new KeyValueBulkDictionaryDataBundleWrapper();
        wrapper.setPbdd(data);
        if (restoreData == null) {
            castedSession.addOperation(new KeyValueCreateOperation(this.storage.getDriver(), key, wrapper));
        } else {
            KeyValueBulkDictionaryDataBundleWrapper restoreWrapper = new KeyValueBulkDictionaryDataBundleWrapper();
            restoreWrapper.setPbdd(restoreData);
            castedSession.addOperation(new KeyValueUpdateOperation(this.storage.getDriver(), key, wrapper, restoreWrapper));
        }
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueBulkDictionaryDataBundleWrapper.buildKey(data.getDictionaryType());
        KeyValueBulkDictionaryDataBundleWrapper restoreWrapper = new KeyValueBulkDictionaryDataBundleWrapper();
        restoreWrapper.setPbdd(data);
        castedSession.addOperation(new KeyValueDeleteOperation(this.storage.getDriver(), key, restoreWrapper));
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> cls, PhysicalStorageSession session) throws Exception {
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueBulkDictionaryDataBundleWrapper.buildKey(cls), null);
        if (bundle == null) {
            return null;
        }
        KeyValueBulkDictionaryDataBundleWrapper wrapper = KeyValueBulkDictionaryDataBundleWrapper.unwrap(bundle);
        return wrapper.getPbdd();
    }
}

