/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueNamedValueBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import java.util.Map;

class KeyValueDBPropertiesPhysicalStorage
implements DBPropertiesPhysicalStorage {
    private final KeyValueMasterPhysicalStorage storage;

    KeyValueDBPropertiesPhysicalStorage(KeyValueMasterPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public void putDbProperty(String key, String value, String oldValue) throws Exception {
        if (value == null) {
            this.storage.getDriver().delete(KeyValueNamedValueBundleWrapper.buildKey(key));
        } else {
            KeyValueNamedValueBundleWrapper wrapper = new KeyValueNamedValueBundleWrapper();
            wrapper.setNv(NamedValueHelper.namedValue((String)key, (String)value));
            this.storage.getDriver().put(KeyValueNamedValueBundleWrapper.buildKey(key), wrapper.wrap());
        }
    }

    @Override
    public String getDbProperty(String key) throws Exception {
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueNamedValueBundleWrapper.buildKey(key), null);
        if (bundle == null) {
            return null;
        }
        KeyValueNamedValueBundleWrapper wrapper = KeyValueNamedValueBundleWrapper.unwrap(bundle);
        NamedValue nv = wrapper.getNv();
        if (nv == null) {
            return null;
        }
        return nv.getValue();
    }

    @Override
    public Map<String, String> getAllKeys() throws Exception {
        throw new UnsupportedOperationException();
    }
}

