/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XObjectInput;
import com.gridnine.xtrip.common.util.XObjectOutput;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyValueDictionaryBundleWrapper
implements KeyValueBundleWrapper {
    private PhysicalDictionaryData<? extends BaseDictionary> pdd;

    static String buildKey(String uid) {
        StringBuilder sb = new StringBuilder();
        sb.append(MiscUtil.getSimpleClassName(BaseDictionary.class));
        sb.append('_');
        sb.append(uid);
        return sb.toString();
    }

    public PhysicalDictionaryData<? extends BaseDictionary> getPdd() {
        return this.pdd;
    }

    public void setPdd(PhysicalDictionaryData<? extends BaseDictionary> pdd) {
        this.pdd = pdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueBundle wrap() throws Exception {
        KeyValueBundle bundle = new KeyValueBundle();
        if (this.pdd != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XObjectOutput xoos = new XObjectOutput((OutputStream)baos);){
                xoos.writeString(this.pdd.getUid());
                xoos.writeString(this.pdd.getCode());
                xoos.writeDate(this.pdd.getCreated());
                xoos.writeByteArray(this.pdd.getData());
                xoos.writeBoolean(this.pdd.isDeleted());
                xoos.writeClass(this.pdd.getDictionaryType());
                xoos.writeDate(this.pdd.getModified());
            }
            bundle.setMetadata(baos.toByteArray());
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyValueDictionaryBundleWrapper unwrap(KeyValueBundle bundle) throws Exception {
        KeyValueDictionaryBundleWrapper wrapper = new KeyValueDictionaryBundleWrapper();
        if (bundle.getMetadata() != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bundle.getMetadata());
                 XObjectInput xois = new XObjectInput((InputStream)bais);){
                PhysicalDictionaryData pdd = new PhysicalDictionaryData();
                pdd.setUid(xois.readString());
                pdd.setCode(xois.readString());
                pdd.setCreated(xois.readDate());
                pdd.setData(xois.readByteArray());
                pdd.setDeleted(xois.readBoolean());
                pdd.setDictionaryType(xois.readClass());
                pdd.setModified(xois.readDate());
                wrapper.setPdd(pdd);
            }
        }
        return wrapper;
    }
}

