/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueCreateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDeleteOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDictionaryBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueUpdateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DictionaryMasterPhysicalStorage;
import java.util.Date;
import java.util.List;

class KeyValueDictionaryMasterPhysicalStorage
implements DictionaryMasterPhysicalStorage {
    private final KeyValueMasterPhysicalStorage storage;

    KeyValueDictionaryMasterPhysicalStorage(KeyValueMasterPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueDictionaryBundleWrapper.buildKey(data.getUid());
        KeyValueDictionaryBundleWrapper restoreWrapper = new KeyValueDictionaryBundleWrapper();
        restoreWrapper.setPdd(data);
        castedSession.addOperation(new KeyValueDeleteOperation(this.storage.getDriver(), key, restoreWrapper));
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueDictionaryBundleWrapper.buildKey(data.getUid());
        KeyValueDictionaryBundleWrapper wrapper = new KeyValueDictionaryBundleWrapper();
        wrapper.setPdd(data);
        if (oldData == null) {
            castedSession.addOperation(new KeyValueCreateOperation(this.storage.getDriver(), key, wrapper));
        } else {
            KeyValueDictionaryBundleWrapper restoreWrapper = new KeyValueDictionaryBundleWrapper();
            restoreWrapper.setPdd(oldData);
            castedSession.addOperation(new KeyValueUpdateOperation(this.storage.getDriver(), key, wrapper, restoreWrapper));
        }
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueDictionaryBundleWrapper.buildKey(uid), null);
        if (bundle == null) {
            return null;
        }
        KeyValueDictionaryBundleWrapper wrapper = KeyValueDictionaryBundleWrapper.unwrap(bundle);
        PhysicalDictionaryData<? extends BaseDictionary> pdd = wrapper.getPdd();
        if (pdd == null) {
            return null;
        }
        return pdd.isDeleted() && ignoreDeleted ? null : pdd;
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException();
    }
}

