/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.UpdatePolicy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XObjectInput;
import com.gridnine.xtrip.common.util.XObjectOutput;
import com.gridnine.xtrip.server.db.storage.model.DataFormat;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class KeyValueEntityBundleWrapper
implements KeyValueBundleWrapper {
    private PhysicalEntityData<? extends BaseEntity> ped;
    private final Map<Integer, PhysicalVersionData> pvds = new HashMap<Integer, PhysicalVersionData>();

    static String buildKey(String uid) {
        StringBuilder sb = new StringBuilder();
        sb.append(MiscUtil.getSimpleClassName(BaseEntity.class));
        sb.append('_');
        sb.append(uid);
        return sb.toString();
    }

    public PhysicalEntityData<? extends BaseEntity> getPed() {
        return this.ped;
    }

    public void setPed(PhysicalEntityData<? extends BaseEntity> ped) {
        this.ped = ped;
    }

    public PhysicalVersionData getPvd(int versionNumber) {
        return this.pvds.get(versionNumber);
    }

    public void setPvd(int versionNumber, PhysicalVersionData pvd) {
        this.pvds.put(versionNumber, pvd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueBundle wrap() throws Exception {
        KeyValueBundle bundle = new KeyValueBundle();
        if (this.ped != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XObjectOutput xoos = new XObjectOutput((OutputStream)baos);){
                xoos.writeDate(this.ped.getCreated());
                xoos.writeString(this.ped.getCreatedBy());
                xoos.writeClass(this.ped.getEntityType());
                xoos.writeDate(this.ped.getModified());
                xoos.writeString(this.ped.getModifiedBy());
                xoos.writeEnum((Enum)this.ped.getStatus());
                xoos.writeString(this.ped.getUid());
                xoos.writeEnum((Enum)this.ped.getUpdatePolicy());
                xoos.writeInt(this.ped.getVersionsCount());
                xoos.writeLong(this.ped.getRevision());
            }
            bundle.setMetadata(baos.toByteArray());
        }
        for (Map.Entry<Integer, PhysicalVersionData> entry : this.pvds.entrySet()) {
            if (entry.getValue() == null) {
                bundle.getVersions().put(entry.getKey(), null);
                continue;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XObjectOutput xoos = new XObjectOutput((OutputStream)baos);){
                xoos.writeDate(entry.getValue().getCreated());
                xoos.writeString(entry.getValue().getCreatedBy());
                xoos.writeByteArray(entry.getValue().getData());
                xoos.writeEnum((Enum)entry.getValue().getDataFormat());
                xoos.writeString(entry.getValue().getDataSource());
                xoos.writeDate(entry.getValue().getModified());
                xoos.writeString(entry.getValue().getModifiedBy());
                xoos.writeString(entry.getValue().getUid());
                xoos.writeString(entry.getValue().getVersionNotes());
                xoos.writeInt(entry.getValue().getVersionNumber());
            }
            bundle.getVersions().put(entry.getKey(), baos.toByteArray());
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyValueEntityBundleWrapper unwrap(KeyValueBundle bundle) throws Exception {
        KeyValueEntityBundleWrapper wrapper = new KeyValueEntityBundleWrapper();
        if (bundle.getMetadata() != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bundle.getMetadata());
                 XObjectInput xois = new XObjectInput((InputStream)bais);){
                PhysicalEntityData ped = new PhysicalEntityData();
                ped.setCreated(xois.readDate());
                ped.setCreatedBy(xois.readString());
                ped.setEntityType(xois.readClass());
                ped.setModified(xois.readDate());
                ped.setModifiedBy(xois.readString());
                ped.setStatus((EntityStatus)xois.readEnum(EntityStatus.class));
                ped.setUid(xois.readString());
                ped.setUpdatePolicy((UpdatePolicy)xois.readEnum(UpdatePolicy.class));
                ped.setVersionsCount(xois.readInt());
                ped.setRevision(xois.readLong());
                wrapper.setPed(ped);
            }
        }
        for (Map.Entry<Integer, byte[]> entry : bundle.getVersions().entrySet()) {
            if (entry.getValue() == null) {
                wrapper.setPvd(entry.getKey(), null);
                continue;
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(entry.getValue());
                 XObjectInput xois = new XObjectInput((InputStream)bais);){
                PhysicalVersionData pvd = new PhysicalVersionData();
                pvd.setCreated(xois.readDate());
                pvd.setCreatedBy(xois.readString());
                pvd.setData(xois.readByteArray());
                pvd.setDataFormat((DataFormat)xois.readEnum(DataFormat.class));
                pvd.setDataSource(xois.readString());
                pvd.setModified(xois.readDate());
                pvd.setModifiedBy(xois.readString());
                pvd.setUid(xois.readString());
                pvd.setVersionNotes(xois.readString());
                pvd.setVersionNumber(xois.readInt());
                wrapper.setPvd(entry.getKey(), pvd);
            }
        }
        return wrapper;
    }
}

