/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueCreateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDeleteOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueEntityBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueUpdateOperation;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.EntityMasterPhysicalStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyValueEntityMasterPhysicalStorage
implements EntityMasterPhysicalStorage {
    private final Logger updateLog = LoggerFactory.getLogger((String)(HibernateEntityStorage.class.getName() + ".UPDATE"));
    private final KeyValueMasterPhysicalStorage storage;

    KeyValueEntityMasterPhysicalStorage(KeyValueMasterPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueEntityBundleWrapper.buildKey(etc.getUid());
        KeyValueEntityBundleWrapper wrapper = new KeyValueEntityBundleWrapper();
        KeyValueEntityBundleWrapper restoreWrapper = null;
        wrapper.setPed(etc);
        if (restoreData != null) {
            restoreWrapper = new KeyValueEntityBundleWrapper();
            restoreWrapper.setPed(restoreData);
            if (etc.getVersionsCount() < restoreData.getVersionsCount()) {
                int[] redundantVersionNumbers = new int[restoreData.getVersionsCount() - etc.getVersionsCount()];
                for (int i = etc.getVersionsCount(); i < restoreData.getVersionsCount(); ++i) {
                    redundantVersionNumbers[i - etc.getVersionsCount()] = i;
                }
                List<PhysicalVersionData> redundantVersions = this.getVersions(etc, session, redundantVersionNumbers);
                Iterator<Object> iterator = redundantVersions.iterator();
                while (iterator.hasNext()) {
                    PhysicalVersionData physicalVersionData = (PhysicalVersionData)iterator.next();
                    wrapper.setPvd(physicalVersionData.getVersionNumber(), null);
                    restoreWrapper.setPvd(physicalVersionData.getVersionNumber(), physicalVersionData);
                }
            }
        }
        HashMap<Integer, PhysicalVersionData> executeVersionDatas = new HashMap<Integer, PhysicalVersionData>();
        for (PhysicalVersionData pvd : etc.getVersions()) {
            executeVersionDatas.put(pvd.getVersionNumber(), pvd);
        }
        HashMap<Integer, PhysicalVersionData> restoreVersionDatas = new HashMap<Integer, PhysicalVersionData>();
        if (restoreData != null) {
            for (PhysicalVersionData physicalVersionData : restoreData.getVersions()) {
                restoreVersionDatas.put(physicalVersionData.getVersionNumber(), physicalVersionData);
            }
        }
        for (Map.Entry entry : executeVersionDatas.entrySet()) {
            PhysicalVersionData executePvd = (PhysicalVersionData)entry.getValue();
            PhysicalVersionData restorePvd = (PhysicalVersionData)restoreVersionDatas.get(entry.getKey());
            wrapper.setPvd(executePvd.getVersionNumber(), executePvd);
            if (restorePvd == null) continue;
            restoreWrapper.setPvd(restorePvd.getVersionNumber(), restorePvd);
        }
        if (restoreData != null) {
            castedSession.addOperation(new KeyValueUpdateOperation(this.storage.getDriver(), key, wrapper, restoreWrapper));
            this.updateLog.debug("saving " + etc.getEntityType() + etc.getUid() + ", login = " + UserData.get().getCurrentUser() + ", versionCount = " + etc.getVersionsCount() + ", versions = [" + etc.getVersions().stream().map(v -> Integer.toString(v.getVersionNumber())).collect(Collectors.joining(", ")) + "], revision = " + etc.getRevision() + ", restoredVersionCount = " + restoreData.getVersionsCount() + ", restoredVersions = [" + restoreData.getVersions().stream().map(v -> Integer.toString(v.getVersionNumber())).collect(Collectors.joining(", ")) + "], restoredRevision = " + restoreData.getRevision() + ", thread = " + Thread.currentThread().getName() + ", stacktrace =\n " + DebugUtil.getStackTrace());
        } else {
            castedSession.addOperation(new KeyValueCreateOperation(this.storage.getDriver(), key, wrapper));
            if (this.updateLog.isDebugEnabled()) {
                this.updateLog.debug("saving new " + etc.getEntityType() + etc.getUid() + ", login = " + UserData.get().getCurrentUser() + ", versionCount = " + etc.getVersionsCount() + ", versions = [" + etc.getVersions().stream().map(v -> Integer.toString(v.getVersionNumber())).collect(Collectors.joining(", ")) + "], revision = " + etc.getRevision() + ", thread = " + Thread.currentThread().getName() + ", stacktrace =\n " + DebugUtil.getStackTrace());
            }
        }
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        String key = KeyValueEntityBundleWrapper.buildKey(data.getUid());
        KeyValueEntityBundleWrapper restoreWrapper = new KeyValueEntityBundleWrapper();
        restoreWrapper.setPed(data);
        for (PhysicalVersionData pvd : data.getVersions()) {
            restoreWrapper.setPvd(pvd.getVersionNumber(), pvd);
        }
        castedSession.addOperation(new KeyValueDeleteOperation(this.storage.getDriver(), key, restoreWrapper));
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        if (versionNumber != restoreData.getVersionsCount() - 1) {
            throw new IllegalArgumentException("can only delete last version");
        }
        KeyValueMasterPhysicalStorageSession castedSession = (KeyValueMasterPhysicalStorageSession)session;
        PhysicalVersionData thePvd = null;
        for (PhysicalVersionData pvd : restoreData.getVersions()) {
            if (pvd.getVersionNumber() != versionNumber) continue;
            thePvd = pvd;
            break;
        }
        if (thePvd == null) {
            throw new IllegalArgumentException("restoreData does not contain the version to be deleted");
        }
        String key = KeyValueEntityBundleWrapper.buildKey(data.getUid());
        KeyValueEntityBundleWrapper wrapper = new KeyValueEntityBundleWrapper();
        wrapper.setPed(data);
        wrapper.setPvd(thePvd.getVersionNumber(), null);
        KeyValueEntityBundleWrapper restoreWrapper = new KeyValueEntityBundleWrapper();
        restoreWrapper.setPed(restoreData);
        restoreWrapper.setPvd(thePvd.getVersionNumber(), thePvd);
        castedSession.addOperation(new KeyValueUpdateOperation(this.storage.getDriver(), key, wrapper, restoreWrapper));
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        boolean validVersion = null == versionNumber || versionNumber != -1;
        Integer versionToGet = validVersion ? versionNumber : null;
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueEntityBundleWrapper.buildKey(uid), validVersion ? Collections.singleton(versionToGet) : null);
        if (bundle == null && versionToGet != null) {
            throw new IllegalArgumentException(String.format("tried to load a version of a non-existent entity (uid:%s, class:%s, version:%d)", uid, cls.getName(), versionToGet));
        }
        if (bundle == null) {
            return null;
        }
        KeyValueEntityBundleWrapper wrapper = KeyValueEntityBundleWrapper.unwrap(bundle);
        PhysicalEntityData<? extends BaseEntity> result = wrapper.getPed();
        if (validVersion) {
            int vn = versionNumber == null ? result.getVersionsCount() - 1 : versionNumber;
            PhysicalVersionData pvd = wrapper.getPvd(vn);
            if (pvd == null) {
                throw new IllegalArgumentException(String.format("tried to load a non-existent version of an existing entity (uid:%s, class:%s, version:%d)", uid, cls.getName(), vn));
            }
            result.getVersions().add(pvd);
        }
        return result;
    }

    private static Collection<Integer> getVersionNumbers(int ... versionNumbers) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int versionNumber : versionNumbers) {
            result.add(versionNumber);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, int ... versionNumbers) throws Exception {
        if (versionNumbers == null || versionNumbers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PhysicalVersionData> result = new ArrayList<PhysicalVersionData>(versionNumbers.length);
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueEntityBundleWrapper.buildKey(entityData.getUid()), KeyValueEntityMasterPhysicalStorage.getVersionNumbers(versionNumbers));
        if (bundle == null) {
            throw new IllegalArgumentException("tried to load versions of a non-existent entity");
        }
        KeyValueEntityBundleWrapper wrapper = KeyValueEntityBundleWrapper.unwrap(bundle);
        for (int versionNumber : versionNumbers) {
            PhysicalVersionData pvd = wrapper.getPvd(versionNumber);
            if (pvd == null) {
                throw new IllegalArgumentException("not all (or none) requested versions found");
            }
            result.add(pvd);
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        KeyValueBundle bundle = this.storage.getDriver().get(KeyValueEntityBundleWrapper.buildKey(uid), null);
        if (bundle == null) {
            return false;
        }
        KeyValueEntityBundleWrapper wrapper = KeyValueEntityBundleWrapper.unwrap(bundle);
        PhysicalEntityData<? extends BaseEntity> ped = wrapper.getPed();
        return ped.getStatus() != EntityStatus.VOID;
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        Collection indexes = MetaRegistryHelper.getIndexes((EntityType)MetaRegistryHelper.getEntityType((String)cls.getName()));
        Optional<IndexType> entityIndex = indexes.stream().filter(indexType -> cls.getName().equals(indexType.getEntityId())).findFirst();
        if (entityIndex.isPresent()) {
            SearchQuery query = new SearchQuery();
            if (limit != null) {
                query.setLimit(limit.intValue());
            }
            if (!useCreateDate) {
                if (startDate != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ge((String)"modified", (Object)startDate));
                }
                if (endDate != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.lt((String)"modified", (Object)endDate));
                }
            }
            List data = LogicalStorage.get().getEntityStorage().search(Class.forName(entityIndex.get().getId()), query).getData();
            return data.stream().map(index -> index.getSource().getUid()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        List<String> entityUids = this.getEntityUids(cls, null, null, false, true, null, null, session);
        entityUids.stream().filter(uid -> {
            try {
                return this.isEntityAvailable(cls, (String)uid, session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).map(uid -> {
            try {
                return this.loadEntity(cls, (String)uid, null, session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).forEach(entity -> {
            try {
                this.deleteEntity((PhysicalEntityData)entity, session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        return this.storage.getDriver().has(KeyValueEntityBundleWrapper.buildKey(uid));
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> entityData, PhysicalStorageSession session) throws Exception {
        ArrayList<PhysicalVersionMetadataData> result = new ArrayList<PhysicalVersionMetadataData>();
        KeyValueBundle bundle = this.storage.getDriver().all(KeyValueEntityBundleWrapper.buildKey(entityData.getUid()));
        if (bundle != null) {
            KeyValueEntityBundleWrapper wrapper = KeyValueEntityBundleWrapper.unwrap(bundle);
            for (Integer versionNumber : new TreeSet<Integer>(bundle.getVersions().keySet())) {
                PhysicalVersionData pvd = wrapper.getPvd(versionNumber);
                result.add(PhysicalVersionMetadataData.fromPhysicalVersionData(pvd));
            }
        }
        return result;
    }
}

