/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueAssetMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBulkDictionaryMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueDictionaryMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueEntityMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueMasterPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueStorageDriver;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.AssetMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BulkDictionaryMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DictionaryMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.EntityMasterPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterPhysicalStorage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueMasterPhysicalStorage
implements MasterPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KeyValueEntityMasterPhysicalStorage entityStorage;
    private final KeyValueDictionaryMasterPhysicalStorage dictionaryStorage;
    private final KeyValueBulkDictionaryMasterPhysicalStorage bulkDictionaryStorage;
    private final KeyValueAssetMasterPhysicalStorage assetStorage;
    private final KeyValueDBPropertiesPhysicalStorage dbPropertiesStorage;
    private final KeyValueStorageDriver driver;
    private boolean disposed;
    private final String uid;
    final KeyValueMasterPhysicalStorageConfiguration config;

    public KeyValueMasterPhysicalStorage(KeyValueMasterPhysicalStorageConfiguration configuration) throws Exception {
        this.log.debug("initializing...");
        this.config = configuration;
        this.uid = configuration.getUid();
        this.driver = (KeyValueStorageDriver)Class.forName(configuration.getDriverClass()).newInstance();
        this.driver.configure(configuration.getParameters());
        this.log.debug(String.format("created and configured driver %s", configuration.getDriverClass()));
        this.log.debug("creating entity storage...");
        this.entityStorage = new KeyValueEntityMasterPhysicalStorage(this);
        this.log.debug("creating dictionary storage...");
        this.dictionaryStorage = new KeyValueDictionaryMasterPhysicalStorage(this);
        this.log.debug("creating bulk dictionary storage...");
        this.bulkDictionaryStorage = new KeyValueBulkDictionaryMasterPhysicalStorage(this);
        this.log.debug("creating asset storage...");
        this.assetStorage = new KeyValueAssetMasterPhysicalStorage(this);
        this.log.debug("creating db properties storage...");
        this.dbPropertiesStorage = new KeyValueDBPropertiesPhysicalStorage(this);
    }

    KeyValueStorageDriver getDriver() {
        return this.driver;
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return new KeyValueMasterPhysicalStorageSession();
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        this.log.debug("BEGIN setupScheme");
        this.getDriver().setupScheme(cleanupMode);
    }

    @Override
    public boolean checkHealth() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        this.log.debug("BEGIN checkHealth");
        return this.getDriver().checkHealth();
    }

    @Override
    public void dispose() {
        this.getDriver().dispose();
        this.disposed = true;
    }

    @Override
    public void maintain() throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        this.getDriver().maintain();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public EntityMasterPhysicalStorage getEntityStorage() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.entityStorage;
    }

    @Override
    public DictionaryMasterPhysicalStorage getDictionaryStorage() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryMasterPhysicalStorage getBulkDictionaryStorage() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetMasterPhysicalStorage getAssetStorage() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.dbPropertiesStorage;
    }
}

