/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueMasterPhysicalStorageSession
implements PhysicalStorageSession {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean open = true;
    private boolean active = false;
    private final List<KeyValueOperation> operations = new ArrayList<KeyValueOperation>();

    public void addOperation(KeyValueOperation operation) {
        this.operations.add(operation);
    }

    void addOperations(Collection<KeyValueOperation> operations) {
        this.operations.addAll(operations);
    }

    @Override
    public void begin() throws Exception {
        this.operations.clear();
        this.active = true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void commit() throws Exception {
        int i;
        if (!this.open) {
            throw new IllegalStateException("session already closed");
        }
        if (!this.active) {
            throw new IllegalStateException("session not active (call begin)");
        }
        this.log.debug("BEGIN commit");
        int operationsSize = this.operations.size();
        this.log.debug(String.format("%d operations to be executed", operationsSize));
        try {
            for (i = 0; i < operationsSize; ++i) {
                KeyValueOperation operation = this.operations.get(i);
                operation.execute();
                this.log.debug(String.format("executed operation %d of %d: %s", i + 1, operationsSize, operation));
            }
        }
        catch (Throwable t) {
            this.log.error("exception while executing operations", t);
            this.log.debug(String.format("%d operations to be restored", i));
            --i;
            while (i >= 0) {
                KeyValueOperation operation = this.operations.get(i);
                operation.restore();
                this.log.debug(String.format("restored operation %d of %d: %s", i + 1, operationsSize, operation));
                --i;
            }
            throw new Exception("commit failed", t);
        }
        finally {
            this.log.debug("END commit");
            this.operations.clear();
        }
    }

    @Override
    public void rollback() throws Exception {
        if (!this.open) {
            throw new IllegalStateException("session already closed");
        }
        if (!this.active) {
            throw new IllegalStateException("session not active (call begin)");
        }
        this.operations.clear();
    }

    @Override
    public void close() throws Exception {
        this.open = false;
    }
}

