/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.keyvalue;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XObjectInput;
import com.gridnine.xtrip.common.util.XObjectOutput;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.KeyValueBundleWrapper;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyValueNamedValueBundleWrapper
implements KeyValueBundleWrapper {
    private NamedValue nv;

    static String buildKey(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(MiscUtil.getSimpleClassName(NamedValue.class));
        sb.append('_');
        sb.append(name);
        return sb.toString();
    }

    public NamedValue getNv() {
        return this.nv;
    }

    public void setNv(NamedValue nv) {
        this.nv = nv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueBundle wrap() throws Exception {
        KeyValueBundle bundle = new KeyValueBundle();
        if (this.nv != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 XObjectOutput xoos = new XObjectOutput((OutputStream)baos);){
                xoos.writeString(this.nv.getName());
                xoos.writeString(this.nv.getValue());
            }
            bundle.setMetadata(baos.toByteArray());
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyValueNamedValueBundleWrapper unwrap(KeyValueBundle bundle) throws Exception {
        KeyValueNamedValueBundleWrapper wrapper = new KeyValueNamedValueBundleWrapper();
        if (bundle.getMetadata() != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bundle.getMetadata());
                 XObjectInput xois = new XObjectInput((InputStream)bais);){
                NamedValue nv = new NamedValue();
                nv.setName(xois.readString());
                nv.setValue(xois.readString());
                wrapper.setNv(nv);
            }
        }
        return wrapper;
    }
}

