/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DelegatingPhysicalStorageConfiguration;
import java.util.Map;

public abstract class BaseDelegatingPhysicalStorage {
    protected final PhysicalStorage delegate;
    private final String uid;

    public BaseDelegatingPhysicalStorage(DelegatingPhysicalStorageConfiguration configuration) throws Exception {
        this.uid = configuration.getUid();
        this.delegate = (PhysicalStorage)Class.forName(configuration.getDelegateClassName()).getConstructor(configuration.getDelegateConfiguration().getClass()).newInstance(configuration.getDelegateConfiguration());
    }

    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        return this.delegate.createSession(context);
    }

    public void setupScheme(boolean cleanupMode) throws Exception {
        this.delegate.setupScheme(cleanupMode);
    }

    public boolean checkHealth() {
        return this.delegate.checkHealth();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void maintain() throws Exception {
        this.delegate.maintain();
    }

    public String getUid() {
        return this.uid;
    }

    public PhysicalStorage getDelegate() {
        return this.delegate;
    }
}

