/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.AssetIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BaseDelegatingPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BulkDictionaryIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DelegatingPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DictionaryIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.EntityIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.IndexPhysicalStorage;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DelegatingIndexPhysicalStorage
extends BaseDelegatingPhysicalStorage
implements IndexPhysicalStorage {
    private final DelegatingEntityIndexPhysicalStorage entityStorage;
    private final DelegatingDictionaryIndexPhysicalStorage dictionaryStorage;
    private final DelegatingBulkDictionaryIndexPhysicalStorage bulkDictionaryStorage;
    private final DelegatingAssetIndexPhysicalStorage assetsStorage;

    public DelegatingIndexPhysicalStorage(DelegatingPhysicalStorageConfiguration config) throws Exception {
        super(config);
        this.entityStorage = new DelegatingEntityIndexPhysicalStorage(this.delegate.getEntityStorage());
        this.dictionaryStorage = new DelegatingDictionaryIndexPhysicalStorage(this.delegate.getDictionaryStorage());
        this.bulkDictionaryStorage = new DelegatingBulkDictionaryIndexPhysicalStorage(this.delegate.getBulkDictionaryStorage());
        this.assetsStorage = new DelegatingAssetIndexPhysicalStorage(this.delegate.getAssetStorage());
    }

    @Override
    public EntityIndexPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryIndexPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryIndexPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetIndexPhysicalStorage getAssetStorage() {
        return this.assetsStorage;
    }

    static class DelegatingAssetIndexPhysicalStorage
    implements AssetIndexPhysicalStorage {
        private final AssetPhysicalStorage delegate;

        DelegatingAssetIndexPhysicalStorage(AssetPhysicalStorage del) {
            this.delegate = del;
        }

        @Override
        public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
            this.delegate.saveAsset(asset, restoreData, session);
        }

        @Override
        public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteAsset(asset, session);
        }

        @Override
        public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
            return this.delegate.searchAssets(cls, query, session);
        }

        @Override
        public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
            return this.delegate.searchAssets(cls, query, session);
        }
    }

    static class DelegatingBulkDictionaryIndexPhysicalStorage
    implements BulkDictionaryIndexPhysicalStorage {
        private final BulkDictionaryPhysicalStorage delegate;

        DelegatingBulkDictionaryIndexPhysicalStorage(BulkDictionaryPhysicalStorage del) {
            this.delegate = del;
        }

        @Override
        public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
            this.delegate.updateData(data, restoreData, session);
        }

        @Override
        public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteData(data, session);
        }

        @Override
        public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
            return this.delegate.loadMetadata(session);
        }
    }

    static class DelegatingDictionaryIndexPhysicalStorage
    implements DictionaryIndexPhysicalStorage {
        private final DictionaryPhysicalStorage delegate;

        DelegatingDictionaryIndexPhysicalStorage(DictionaryPhysicalStorage del) {
            this.delegate = del;
        }

        @Override
        public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteDictionary(data, session);
        }

        @Override
        public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
            this.delegate.saveDictionary(data, oldData, session);
        }

        @Override
        public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteAll(cls, session);
        }

        @Override
        public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
            return this.delegate.findDictionaryByCode(cls, code, deleted, session);
        }

        @Override
        public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSince, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
            return this.delegate.loadAll(modifiedSince, deleted, dictClass, ignoredTypes, session);
        }
    }

    static class DelegatingEntityIndexPhysicalStorage
    implements EntityIndexPhysicalStorage {
        private final EntityPhysicalStorage delegate;

        public DelegatingEntityIndexPhysicalStorage(EntityPhysicalStorage del) {
            this.delegate = del;
        }

        @Override
        public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
            this.delegate.saveEntity(etc, restoreData, session);
        }

        @Override
        public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteEntity(data, session);
        }

        @Override
        public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteVersion(data, versionNumber, restoreData, session);
        }

        @Override
        public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteAllEntities(cls, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
            return this.delegate.searchEntity(cls, query, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
            return this.delegate.searchEntity(cls, query, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> cls, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteIndexes(cls, containerUid, restoreData, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> cls, Map<EntityPhysicalStorage, List<D>> indexes, String containerUid, PhysicalStorageSession session) throws Exception {
            this.delegate.saveIndexes(cls, indexes, containerUid, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
            return this.delegate.getIndexes(indexClass, uid, session);
        }

        @Override
        public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
            return this.delegate.getEntityModifications(types, timeStampFrom, timeStampTo, session);
        }

        @Override
        public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
            this.delegate.deleteAllIndexes(cls, session);
        }
    }
}

