/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BaseAssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageDeleteAssetOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.AssetStorageSaveAssetOperation;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexAssetStorage
implements AssetPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MasterIndexPhysicalStorage storage;
    private final boolean cleanupBlobs;
    private final Map<Class<?>, Set<String>> assetsWithBlobs = new HashMap();

    public MasterIndexAssetStorage(MasterIndexPhysicalStorage aStorage, boolean cleanupIndexBlobs) {
        this.storage = aStorage;
        this.cleanupBlobs = cleanupIndexBlobs;
        for (Map.Entry<Class<?>, Class<?>> item : ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClasses().entrySet()) {
            Class<?> dataClass = item.getValue();
            for (PropertyDescriptor property : PropertyUtils.getPropertyDescriptors(dataClass)) {
                if (!byte[].class.equals(property.getPropertyType())) continue;
                Set<String> set = this.assetsWithBlobs.get(item.getKey());
                if (set == null) {
                    set = new HashSet<String>();
                    this.assetsWithBlobs.put(item.getKey(), set);
                }
                set.add(property.getName());
            }
        }
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        SearchResult<A> result = this.storage.getIndexStorage().getAssetStorage().searchAssets(cls, query, castedSession.getIndexSession());
        if (!this.cleanupBlobs || !this.assetsWithBlobs.containsKey(cls) || result.getData().isEmpty()) {
            return result;
        }
        ArrayList<A> data = new ArrayList<A>();
        for (BaseAsset item : result.getData()) {
            if (item == null) {
                this.log.warn("search result returned null item");
                continue;
            }
            PhysicalAssetData<A> assetData = this.storage.getMasterStorage().getAssetStorage().loadAsset(cls, item.getUid(), castedSession.getMasterSession());
            if (assetData == null) {
                this.log.error(String.format("there is no asset of type %s with uid %s in master storage", cls, item.getUid()));
                continue;
            }
            A asset = assetData.getAsset();
            if (query.getPreferredProperties().isEmpty()) {
                data.add(asset);
                continue;
            }
            BaseAssetData<A> dataClone = ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls).newInstance();
            dataClone.fromAsset(asset);
            data.add(dataClone.toAsset(query.getPreferredProperties()));
        }
        result.getData().clear();
        result.getData().addAll(data);
        return result;
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getAssetStorage().searchAssets(cls, query, castedSession.getIndexSession());
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new AssetStorageSaveAssetOperation<A>(asset, restoreData));
        ArrayList<SaveAssetCallable<A>> tasks = new ArrayList<SaveAssetCallable<A>>(2);
        tasks.add(new SaveAssetCallable<A>(this.storage.getMasterStorage().getAssetStorage(), asset, restoreData, castedSession.getMasterSession()));
        tasks.add(new SaveAssetCallable<A>(this.storage.getIndexStorage().getAssetStorage(), asset, restoreData, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        Throwable firstException = null;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("saveAsset succeeded for master storage");
        }
        catch (Throwable t) {
            firstException = t;
            success = false;
            this.log.error("saveAsset failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("saveAsset succeeded for index storage");
        }
        catch (Throwable t) {
            if (firstException == null) {
                firstException = t;
            }
            success = false;
            this.log.error("saveAsset failed for index storage", t);
        }
        if (!success) {
            if (firstException != null) {
                throw new Exception("saveAsset failed", firstException);
            }
            throw new Exception("saveAsset failed");
        }
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new AssetStorageDeleteAssetOperation<A>(asset));
        ArrayList<DeleteAssetCallable<A>> tasks = new ArrayList<DeleteAssetCallable<A>>(2);
        tasks.add(new DeleteAssetCallable<A>(this.storage.getMasterStorage().getAssetStorage(), asset, castedSession.getMasterSession()));
        tasks.add(new DeleteAssetCallable<A>(this.storage.getIndexStorage().getAssetStorage(), asset, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteAsset succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAsset failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteAsset succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAsset failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteAsset failed");
        }
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getAssetStorage().loadAsset(cls, uid, castedSession.getMasterSession());
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getAssetStorage().getAssetUids(cls, startDate, endDate, sortOrder, limit, castedSession.getMasterSession());
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getAssetStorage().isAssetExist(cls, uid, castedSession.getMasterSession());
    }

    private static class DeleteAssetCallable<A extends BaseAsset>
    implements Callable<Object> {
        private final BaseAssetPhysicalStorage storage;
        private final PhysicalAssetData<A> asset;
        private final PhysicalStorageSession session;

        DeleteAssetCallable(BaseAssetPhysicalStorage storage, PhysicalAssetData<A> asset, PhysicalStorageSession session) {
            this.storage = storage;
            this.asset = asset;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteAsset(this.asset, this.session);
            return null;
        }
    }

    private static class SaveAssetCallable<A extends BaseAsset>
    implements Callable<Object> {
        private final BaseAssetPhysicalStorage storage;
        private final PhysicalAssetData<A> asset;
        private final PhysicalAssetData<A> restoreData;
        private final PhysicalStorageSession session;

        SaveAssetCallable(BaseAssetPhysicalStorage storage, PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) {
            this.storage = storage;
            this.asset = asset;
            this.restoreData = restoreData;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.saveAsset(this.asset, this.restoreData, this.session);
            return null;
        }
    }
}

