/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BaseBulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageDeleteDataOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.BulkDictionaryStorageUpdateDataOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexBulkDictionaryStorage
implements BulkDictionaryPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MasterIndexPhysicalStorage storage;

    public MasterIndexBulkDictionaryStorage(MasterIndexPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getBulkDictionaryStorage().loadMetadata(castedSession.getIndexSession());
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getBulkDictionaryStorage().loadData(key, castedSession.getMasterSession());
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new BulkDictionaryStorageUpdateDataOperation<D>(data, restoreData));
        ArrayList<UpdateDataCallable<D>> tasks = new ArrayList<UpdateDataCallable<D>>(2);
        tasks.add(new UpdateDataCallable<D>(this.storage.getMasterStorage().getBulkDictionaryStorage(), data, restoreData, castedSession.getMasterSession()));
        tasks.add(new UpdateDataCallable<D>(this.storage.getIndexStorage().getBulkDictionaryStorage(), data, restoreData, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("updateData succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("updateData failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("updateData succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("updateData failed for index storage", t);
        }
        if (!success) {
            throw new Exception("updateData failed");
        }
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new BulkDictionaryStorageDeleteDataOperation<D>(data));
        ArrayList<DeleteDataCallable<D>> tasks = new ArrayList<DeleteDataCallable<D>>(2);
        tasks.add(new DeleteDataCallable<D>(this.storage.getMasterStorage().getBulkDictionaryStorage(), data, castedSession.getMasterSession()));
        tasks.add(new DeleteDataCallable<D>(this.storage.getIndexStorage().getBulkDictionaryStorage(), data, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteData succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteData failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteData succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteData failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteData failed");
        }
    }

    private static class DeleteDataCallable<D extends BaseDictionary>
    implements Callable<Object> {
        private final BaseBulkDictionaryPhysicalStorage storage;
        private final PhysicalBulkDictionaryData<D> data;
        private final PhysicalStorageSession session;

        DeleteDataCallable(BaseBulkDictionaryPhysicalStorage storage, PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteData(this.data, this.session);
            return null;
        }
    }

    private static class UpdateDataCallable<D extends BaseDictionary>
    implements Callable<Object> {
        private final BaseBulkDictionaryPhysicalStorage storage;
        private final PhysicalBulkDictionaryData<D> data;
        private final PhysicalBulkDictionaryData<D> restoreData;
        private final PhysicalStorageSession session;

        UpdateDataCallable(BaseBulkDictionaryPhysicalStorage storage, PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.restoreData = restoreData;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.updateData(this.data, this.restoreData, this.session);
            return null;
        }
    }
}

