/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BaseDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteAllOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageDeleteDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.DictionaryStorageSaveDictionaryOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexDictionaryStorage
implements DictionaryPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MasterIndexPhysicalStorage storage;
    private final boolean cleanupBlobls;

    public MasterIndexDictionaryStorage(MasterIndexPhysicalStorage storage, boolean cleanup) {
        this.storage = storage;
        this.cleanupBlobls = cleanup;
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        PhysicalDictionaryData<D> result = this.storage.getIndexStorage().getDictionaryStorage().findDictionaryByCode(cls, code, deleted, castedSession.getIndexSession());
        if (!this.cleanupBlobls || result == null) {
            return result;
        }
        return this.findDictionaryByUid(cls, result.getUid(), false, session);
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, castedSession.getMasterSession());
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageDeleteDictionaryOperation<D>(data));
        ArrayList<DeleteDictionaryCallable<D>> tasks = new ArrayList<DeleteDictionaryCallable<D>>(2);
        tasks.add(new DeleteDictionaryCallable<D>(this.storage.getMasterStorage().getDictionaryStorage(), data, castedSession.getMasterSession()));
        tasks.add(new DeleteDictionaryCallable<D>(this.storage.getIndexStorage().getDictionaryStorage(), data, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteDictionary succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteDictionary failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteDictionary succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteDictionary failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteDictionary failed");
        }
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageSaveDictionaryOperation<D>(data, oldData));
        ArrayList<SaveDictionaryCallable<D>> tasks = new ArrayList<SaveDictionaryCallable<D>>(2);
        tasks.add(new SaveDictionaryCallable<D>(this.storage.getMasterStorage().getDictionaryStorage(), data, oldData, castedSession.getMasterSession()));
        tasks.add(new SaveDictionaryCallable<D>(this.storage.getIndexStorage().getDictionaryStorage(), data, oldData, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        Throwable firstException = null;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("saveDictionary succeeded for master storage");
        }
        catch (Throwable t) {
            firstException = t;
            success = false;
            this.log.error("saveDictionary failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("saveDictionary succeeded for index storage");
        }
        catch (Throwable t) {
            if (firstException == null) {
                firstException = t;
            }
            success = false;
            this.log.error("saveDictionary failed for index storage", t);
        }
        if (!success) {
            if (firstException != null) {
                throw new Exception("saveDictionary failed", firstException);
            }
            throw new Exception("saveDictionary failed");
        }
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSince, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        List<PhysicalDictionaryData<?>> result = this.storage.getIndexStorage().getDictionaryStorage().loadAll(modifiedSince, deleted, dictClass, ignoredTypes, castedSession.getIndexSession());
        if (!this.cleanupBlobls || result.isEmpty()) {
            return result;
        }
        ArrayList correctedResult = new ArrayList();
        for (PhysicalDictionaryData<?> item : result) {
            PhysicalDictionaryData<?> fullItem = this.findDictionaryByUid(item.getDictionaryType(), item.getUid(), false, session);
            if (fullItem == null) {
                this.log.error(String.format("dictionary %s with code %s with uid %s is present in index storage but absent in master", item.getDictionaryType(), item.getCode(), item.getUid()));
                continue;
            }
            correctedResult.add(fullItem);
        }
        return correctedResult;
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getDictionaryStorage().getDictionaryUids(cls, startDate, endDate, useCreateDate, ignoreDeleted, sortOrder, limit, castedSession.getMasterSession());
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new DictionaryStorageDeleteAllOperation(cls));
        ArrayList<DeleteAllCallable<D>> tasks = new ArrayList<DeleteAllCallable<D>>(2);
        tasks.add(new DeleteAllCallable<D>(this.storage.getMasterStorage().getDictionaryStorage(), cls, castedSession.getMasterSession()));
        tasks.add(new DeleteAllCallable<D>(this.storage.getIndexStorage().getDictionaryStorage(), cls, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteAll succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAll failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteAll succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAll failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteAll failed");
        }
    }

    private static class DeleteAllCallable<D extends BaseDictionary>
    implements Callable<Object> {
        private final BaseDictionaryPhysicalStorage storage;
        private final Class<D> cls;
        private final PhysicalStorageSession session;

        DeleteAllCallable(BaseDictionaryPhysicalStorage storage, Class<D> cls, PhysicalStorageSession session) {
            this.storage = storage;
            this.cls = cls;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteAll(this.cls, this.session);
            return null;
        }
    }

    private static class SaveDictionaryCallable<D extends BaseDictionary>
    implements Callable<Object> {
        private final BaseDictionaryPhysicalStorage storage;
        private final PhysicalDictionaryData<D> data;
        private final PhysicalDictionaryData<D> oldData;
        private final PhysicalStorageSession session;

        SaveDictionaryCallable(BaseDictionaryPhysicalStorage storage, PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.oldData = oldData;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.saveDictionary(this.data, this.oldData, this.session);
            return null;
        }
    }

    private static class DeleteDictionaryCallable<D extends BaseDictionary>
    implements Callable<Object> {
        private final BaseDictionaryPhysicalStorage storage;
        private final PhysicalDictionaryData<D> data;
        private final PhysicalStorageSession session;

        DeleteDictionaryCallable(BaseDictionaryPhysicalStorage storage, PhysicalDictionaryData<D> data, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteDictionary(this.data, this.session);
            return null;
        }
    }
}

