/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BaseEntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllEntitiesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteAllIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteIndexesOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageDeleteVersionOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveEntityOperation;
import com.gridnine.xtrip.server.db.storage.replication.operation.EntityStorageSaveIndexesOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexEntityStorage
implements EntityPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MasterIndexPhysicalStorage storage;

    public MasterIndexEntityStorage(MasterIndexPhysicalStorage storage) {
        this.storage = storage;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getEntityStorage().searchEntity(cls, query, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getEntityStorage().searchEntity(cls, query, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().loadEntity(cls, uid, versionNumber, castedSession.getMasterSession());
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, int ... versionNumbers) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().getVersions(entityData, castedSession.getMasterSession(), versionNumbers);
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> ref, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().getVersionsMetadata(ref, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> cls, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageDeleteIndexesOperation(cls, containerUid, restoreData));
        this.storage.getIndexStorage().getEntityStorage().deleteIndexes(cls, containerUid, restoreData, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> cls, Map<EntityPhysicalStorage, List<D>> indexes, String containerUid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageSaveIndexesOperation(cls, indexes, containerUid));
        this.storage.getIndexStorage().getEntityStorage().saveIndexes(cls, indexes, containerUid, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageSaveEntityOperation<E>(etc, restoreData));
        ArrayList<SaveEntityCallable<E>> tasks = new ArrayList<SaveEntityCallable<E>>(2);
        tasks.add(new SaveEntityCallable<E>(this.storage.getMasterStorage().getEntityStorage(), etc, restoreData, castedSession.getMasterSession()));
        tasks.add(new SaveEntityCallable<E>(this.storage.getIndexStorage().getEntityStorage(), etc, restoreData, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        Throwable firstException = null;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("saveEntity succeeded for master storage");
        }
        catch (Throwable t) {
            firstException = t;
            success = false;
            this.log.error("saveEntity failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("saveEntity succeeded for index storage");
        }
        catch (Throwable t) {
            if (firstException == null) {
                firstException = t;
            }
            success = false;
            this.log.error("saveEntity failed for index storage", t);
        }
        if (!success) {
            if (firstException != null) {
                throw new Exception("saveEntity failed", firstException);
            }
            throw new Exception("saveEntity failed");
        }
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageDeleteEntityOperation<E>(data));
        ArrayList<DeleteEntityCallable<E>> tasks = new ArrayList<DeleteEntityCallable<E>>(2);
        tasks.add(new DeleteEntityCallable<E>(this.storage.getMasterStorage().getEntityStorage(), data, castedSession.getMasterSession()));
        tasks.add(new DeleteEntityCallable<E>(this.storage.getIndexStorage().getEntityStorage(), data, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteEntity succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteEntity failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteEntity succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteEntity failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteEntity failed");
        }
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageDeleteVersionOperation<E>(data, versionNumber, restoreData));
        ArrayList<DeleteVersionCallable<E>> tasks = new ArrayList<DeleteVersionCallable<E>>(2);
        tasks.add(new DeleteVersionCallable<E>(this.storage.getMasterStorage().getEntityStorage(), data, versionNumber, restoreData, castedSession.getMasterSession()));
        tasks.add(new DeleteVersionCallable<E>(this.storage.getIndexStorage().getEntityStorage(), this.cleanupEntity(data), versionNumber, this.cleanupEntity(restoreData), castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteVersion succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteVersion failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteVersion succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteVersion failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteVersion failed");
        }
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String uid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getEntityStorage().getIndexes(indexClass, uid, castedSession.getIndexSession());
    }

    @Override
    public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getIndexStorage().getEntityStorage().getEntityModifications(types, timeStampFrom, timeStampTo, castedSession.getIndexSession());
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().isEntityAvailable(cls, uid, castedSession.getMasterSession());
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().isEntityExist(cls, uid, castedSession.getMasterSession());
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        return this.storage.getMasterStorage().getEntityStorage().getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, castedSession.getMasterSession());
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageDeleteAllEntitiesOperation(cls));
        ArrayList<DeleteAllEntitiesCallable<E>> tasks = new ArrayList<DeleteAllEntitiesCallable<E>>(2);
        tasks.add(new DeleteAllEntitiesCallable<E>(this.storage.getMasterStorage().getEntityStorage(), cls, castedSession.getMasterSession()));
        tasks.add(new DeleteAllEntitiesCallable<E>(this.storage.getIndexStorage().getEntityStorage(), cls, castedSession.getIndexSession()));
        List futures = this.storage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("deleteAllEntities succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAllEntities failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("deleteAllEntities succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("deleteAllEntities failed for index storage", t);
        }
        if (!success) {
            throw new Exception("deleteAllEntities failed");
        }
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
        MasterIndexPhysicalStorageSession castedSession = (MasterIndexPhysicalStorageSession)session;
        castedSession.addOperation(new EntityStorageDeleteAllIndexesOperation(cls));
        this.storage.getIndexStorage().getEntityStorage().deleteAllIndexes(cls, castedSession.getIndexSession());
    }

    private <E extends BaseEntity> PhysicalEntityData<E> cleanupEntity(PhysicalEntityData<E> etc) {
        if (etc == null) {
            return null;
        }
        PhysicalEntityData result = new PhysicalEntityData();
        etc.copy(result);
        for (PhysicalVersionData item : result.getVersions()) {
            item.setData(new byte[0]);
        }
        return result;
    }

    private static class DeleteAllEntitiesCallable<E extends BaseEntity>
    implements Callable<Object> {
        private final BaseEntityPhysicalStorage storage;
        private final Class<E> cls;
        private final PhysicalStorageSession session;

        DeleteAllEntitiesCallable(BaseEntityPhysicalStorage storage, Class<E> cls, PhysicalStorageSession session) {
            this.storage = storage;
            this.cls = cls;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteAllEntities(this.cls, this.session);
            return null;
        }
    }

    private static class DeleteVersionCallable<E extends BaseEntity>
    implements Callable<Object> {
        private final BaseEntityPhysicalStorage storage;
        private final PhysicalEntityData<E> data;
        private final int versionNumber;
        private final PhysicalEntityData<E> restoreData;
        private final PhysicalStorageSession session;

        DeleteVersionCallable(BaseEntityPhysicalStorage storage, PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.versionNumber = versionNumber;
            this.restoreData = restoreData;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteVersion(this.data, this.versionNumber, this.restoreData, this.session);
            return null;
        }
    }

    private static class DeleteEntityCallable<E extends BaseEntity>
    implements Callable<Object> {
        private final BaseEntityPhysicalStorage storage;
        private final PhysicalEntityData<E> data;
        private final PhysicalStorageSession session;

        DeleteEntityCallable(BaseEntityPhysicalStorage storage, PhysicalEntityData<E> data, PhysicalStorageSession session) {
            this.storage = storage;
            this.data = data;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.deleteEntity(this.data, this.session);
            return null;
        }
    }

    private static class SaveEntityCallable<E extends BaseEntity>
    implements Callable<Object> {
        private final BaseEntityPhysicalStorage storage;
        private final PhysicalEntityData<E> etc;
        private final PhysicalEntityData<E> restoreData;
        private final PhysicalStorageSession session;

        SaveEntityCallable(BaseEntityPhysicalStorage storage, PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) {
            this.storage = storage;
            this.etc = etc;
            this.restoreData = restoreData;
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.storage.saveEntity(this.etc, this.restoreData, this.session);
            return null;
        }
    }
}

