/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BasePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.IndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexAssetStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexEntityStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterPhysicalStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexPhysicalStorage
implements PhysicalStorage {
    private final MasterPhysicalStorage masterStorage;
    private final IndexPhysicalStorage indexStorage;
    private final ExecutorServiceFacade executorService;
    private final MasterIndexEntityStorage entityStorage;
    private final MasterIndexDictionaryStorage dictionaryStorage;
    private final MasterIndexBulkDictionaryStorage bulkDictionaryStorage;
    private final MasterIndexAssetStorage assetStorage;
    private final String uid;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public MasterIndexPhysicalStorage(MasterIndexPhysicalStorageConfiguration configuration) throws Exception {
        this.log.debug("initializing...");
        this.uid = configuration.getUid();
        this.log.debug("creating master storage...");
        this.masterStorage = (MasterPhysicalStorage)Class.forName(configuration.getMasterStorageClassName()).getConstructor(configuration.getMasterStorageConfiguration().getClass()).newInstance(configuration.getMasterStorageConfiguration());
        this.log.debug("creating index storage...");
        this.indexStorage = (IndexPhysicalStorage)Class.forName(configuration.getIndexStorageClassName()).getConstructor(configuration.getIndexStorageConfiguration().getClass()).newInstance(configuration.getIndexStorageConfiguration());
        this.log.debug("creating executor service...");
        this.executorService = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newCachedThreadPool("master-index-physical-storage");
        this.log.debug("creating entity storage...");
        this.entityStorage = new MasterIndexEntityStorage(this);
        this.log.debug("creating dictionary storage...");
        this.dictionaryStorage = new MasterIndexDictionaryStorage(this, configuration.isCleanupIndexBlobs());
        this.log.debug("creating bulk dictionary storage...");
        this.bulkDictionaryStorage = new MasterIndexBulkDictionaryStorage(this);
        this.log.debug("creating asset storage...");
        this.assetStorage = new MasterIndexAssetStorage(this, configuration.isCleanupIndexBlobs());
        this.log.debug("initialized");
    }

    ExecutorServiceFacade getExecutorService() {
        return this.executorService;
    }

    public MasterPhysicalStorage getMasterStorage() {
        return this.masterStorage;
    }

    public IndexPhysicalStorage getIndexStorage() {
        return this.indexStorage;
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        ArrayList<CreateSessionCallable> tasks = new ArrayList<CreateSessionCallable>(2);
        tasks.add(new CreateSessionCallable(this.masterStorage, context));
        tasks.add(new CreateSessionCallable(this.indexStorage, context));
        List futures = this.executorService.invokeAll(tasks);
        PhysicalStorageSession masterSession = null;
        PhysicalStorageSession indexSession = null;
        boolean success = true;
        try {
            masterSession = (PhysicalStorageSession)((Future)futures.get(0)).get();
            this.log.debug("createSession succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("createSession failed for master storage", t);
        }
        try {
            indexSession = (PhysicalStorageSession)((Future)futures.get(1)).get();
            this.log.debug("createSession succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("createSession failed for index storage", t);
        }
        if (!success) {
            if (masterSession != null) {
                try {
                    masterSession.close();
                    this.log.debug("closeSession succeeded for master storage");
                }
                catch (Throwable t) {
                    this.log.error("closeSession failed for master storage", t);
                }
            }
            if (indexSession != null) {
                try {
                    indexSession.close();
                    this.log.debug("closeSession succeeded for index storage");
                }
                catch (Throwable t) {
                    this.log.error("closeSession failed for index storage", t);
                }
            }
            throw new Exception("createSession failed");
        }
        return new MasterIndexPhysicalStorageSession(masterSession, indexSession, this, context);
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        ArrayList<SetupSchemeCallable> tasks = new ArrayList<SetupSchemeCallable>(2);
        tasks.add(new SetupSchemeCallable(this.masterStorage, cleanupMode));
        tasks.add(new SetupSchemeCallable(this.indexStorage, cleanupMode));
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("setupScheme succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("setupScheme failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("setupScheme succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("setupScheme failed for index storage", t);
        }
        if (!success) {
            throw new Exception("setupScheme failed");
        }
    }

    @Override
    public boolean checkHealth() {
        boolean success = true;
        if (!this.masterStorage.checkHealth()) {
            this.log.error("checkHealth failed for master storage");
            success = false;
        }
        if (!this.indexStorage.checkHealth()) {
            this.log.error("checkHealth failed for index storage");
            success = false;
        }
        return success;
    }

    @Override
    public void dispose() {
        ArrayList<DisposeCallable> tasks = new ArrayList<DisposeCallable>(2);
        tasks.add(new DisposeCallable(this.masterStorage));
        tasks.add(new DisposeCallable(this.indexStorage));
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (Throwable t) {
            this.log.error("failed disposing substorages", t);
        }
        this.executorService.dispose();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.masterStorage.getDBPropertiesStorage();
    }

    @Override
    public void maintain() throws Exception {
        ArrayList<MaintainCallable> tasks = new ArrayList<MaintainCallable>(2);
        tasks.add(new MaintainCallable(this.masterStorage));
        tasks.add(new MaintainCallable(this.indexStorage));
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("maintain succeeded for master storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.debug("maintain failed for master storage", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("maintain succeeded for index storage");
        }
        catch (Throwable t) {
            success = false;
            this.log.debug("maintain failed for index storage", t);
        }
        if (!success) {
            throw new Exception("maintain failed");
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    private static class MaintainCallable
    implements Callable<Object> {
        private final BasePhysicalStorage storage;

        MaintainCallable(BasePhysicalStorage storage) {
            this.storage = storage;
        }

        @Override
        public Object call() throws Exception {
            this.storage.maintain();
            return null;
        }
    }

    private static class DisposeCallable
    implements Callable<Object> {
        private final BasePhysicalStorage storage;

        DisposeCallable(BasePhysicalStorage storage) {
            this.storage = storage;
        }

        @Override
        public Object call() throws Exception {
            this.storage.dispose();
            return null;
        }
    }

    private static class SetupSchemeCallable
    implements Callable<Object> {
        private final BasePhysicalStorage storage;
        private final boolean cleanupMode;

        SetupSchemeCallable(BasePhysicalStorage storage, boolean cleanupMode) {
            this.storage = storage;
            this.cleanupMode = cleanupMode;
        }

        @Override
        public Object call() throws Exception {
            this.storage.setupScheme(this.cleanupMode);
            return null;
        }
    }

    private static class CreateSessionCallable
    implements Callable<PhysicalStorageSession> {
        private final BasePhysicalStorage storage;
        private final Map<String, Object> context;

        CreateSessionCallable(BasePhysicalStorage storage, Map<String, Object> context) {
            this.storage = storage;
            this.context = context;
        }

        @Override
        public PhysicalStorageSession call() throws Exception {
            return this.storage.createSession(this.context);
        }
    }
}

