/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.masterindex;

import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.AssetPhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.BulkDictionaryPhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.DictionaryPhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.EntityIndexPhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.EntityMasterPhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.replication.masterindex.PhysicalStorageOperationProxy;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterIndexPhysicalStorageSession
implements PhysicalStorageSession {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PhysicalStorageSession masterSession;
    private final PhysicalStorageSession indexSession;
    final MasterIndexPhysicalStorage masterIndexStorage;
    final List<PhysicalStorageOperation> operations = new ArrayList<PhysicalStorageOperation>();
    final Map<String, Object> context;

    public MasterIndexPhysicalStorageSession(PhysicalStorageSession masterSession, PhysicalStorageSession indexSession, MasterIndexPhysicalStorage masterIndexStorage, Map<String, Object> context) {
        this.masterSession = masterSession;
        this.indexSession = indexSession;
        this.masterIndexStorage = masterIndexStorage;
        this.context = context;
    }

    public PhysicalStorageSession getMasterSession() {
        return this.masterSession;
    }

    public PhysicalStorageSession getIndexSession() {
        return this.indexSession;
    }

    public void addOperation(PhysicalStorageOperation operation) {
        this.operations.add(operation);
    }

    @Override
    public void begin() throws Exception {
        this.operations.clear();
        ArrayList<BeginCallable> tasks = new ArrayList<BeginCallable>(2);
        tasks.add(new BeginCallable(this.masterSession));
        tasks.add(new BeginCallable(this.indexSession));
        List futures = this.masterIndexStorage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("begin succeeded for master session");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("begin failed for master session", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("begin succeeded for index session");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("begin failed for index session", t);
        }
        if (!success) {
            throw new Exception("begin failed");
        }
    }

    @Override
    public boolean isOpen() {
        return this.masterSession.isOpen() || this.indexSession.isOpen();
    }

    @Override
    public void commit() throws Exception {
        Throwable error;
        boolean indexSuccess;
        boolean masterSuccess;
        block8: {
            ArrayList<CommitCallable> commits = new ArrayList<CommitCallable>(2);
            commits.add(new CommitCallable(this.masterSession, "master", LogicalStorage.get().getUser()));
            commits.add(new CommitCallable(this.indexSession, "index", LogicalStorage.get().getUser()));
            List futures = this.masterIndexStorage.getExecutorService().invokeAll(commits);
            masterSuccess = true;
            indexSuccess = true;
            error = null;
            try {
                ((Future)futures.get(0)).get();
            }
            catch (Throwable t) {
                masterSuccess = false;
                error = t;
            }
            try {
                ((Future)futures.get(1)).get();
            }
            catch (Throwable t) {
                indexSuccess = false;
                if (error != null) break block8;
                error = t;
            }
        }
        if (error != null) {
            ArrayList<RestoreCallable> restores = new ArrayList<RestoreCallable>();
            if (masterSuccess) {
                restores.add(new RestoreCallable(new PhysicalStorageOperationProxy(new EntityMasterPhysicalStorageOperationProxy(this.masterIndexStorage.getMasterStorage().getEntityStorage()), new DictionaryPhysicalStorageOperationProxy(this.masterIndexStorage.getMasterStorage().getDictionaryStorage()), new BulkDictionaryPhysicalStorageOperationProxy(this.masterIndexStorage.getMasterStorage().getBulkDictionaryStorage()), new AssetPhysicalStorageOperationProxy(this.masterIndexStorage.getMasterStorage().getAssetStorage()), new Callable<PhysicalStorageSession>(){

                    @Override
                    public PhysicalStorageSession call() throws Exception {
                        return MasterIndexPhysicalStorageSession.this.masterIndexStorage.getMasterStorage().createSession(MasterIndexPhysicalStorageSession.this.context);
                    }
                }), "master", LogicalStorage.get().getUser()));
            }
            if (indexSuccess) {
                restores.add(new RestoreCallable(new PhysicalStorageOperationProxy(new EntityIndexPhysicalStorageOperationProxy(this.masterIndexStorage.getIndexStorage().getEntityStorage()), new DictionaryPhysicalStorageOperationProxy(this.masterIndexStorage.getIndexStorage().getDictionaryStorage()), new BulkDictionaryPhysicalStorageOperationProxy(this.masterIndexStorage.getIndexStorage().getBulkDictionaryStorage()), new AssetPhysicalStorageOperationProxy(this.masterIndexStorage.getIndexStorage().getAssetStorage()), new Callable<PhysicalStorageSession>(){

                    @Override
                    public PhysicalStorageSession call() throws Exception {
                        return MasterIndexPhysicalStorageSession.this.masterIndexStorage.getIndexStorage().createSession(MasterIndexPhysicalStorageSession.this.context);
                    }
                }), "index", LogicalStorage.get().getUser()));
            }
            if (restores.size() > 0) {
                this.masterIndexStorage.getExecutorService().invokeAll(restores);
            }
            throw new Exception("commit failed", error);
        }
    }

    @Override
    public void rollback() throws Exception {
        ArrayList<RollbackCallable> tasks = new ArrayList<RollbackCallable>(2);
        tasks.add(new RollbackCallable(this.masterSession));
        tasks.add(new RollbackCallable(this.indexSession));
        List futures = this.masterIndexStorage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        try {
            ((Future)futures.get(0)).get();
            this.log.debug("rollback succeeded for master session");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("rollback failed for master session", t);
        }
        try {
            ((Future)futures.get(1)).get();
            this.log.debug("rollback succeeded for index session");
        }
        catch (Throwable t) {
            success = false;
            this.log.error("rollback failed for index session", t);
        }
        if (!success) {
            throw new Exception("rollback failed");
        }
    }

    @Override
    public void close() throws Exception {
        ArrayList<CloseCallable> tasks = new ArrayList<CloseCallable>(2);
        ArrayList<String> openSessions = new ArrayList<String>();
        if (this.masterSession.isOpen()) {
            tasks.add(new CloseCallable(this.masterSession));
            openSessions.add("master");
        } else {
            this.log.debug("master session is already closed");
        }
        if (this.indexSession.isOpen()) {
            tasks.add(new CloseCallable(this.indexSession));
            openSessions.add("index");
        } else {
            this.log.debug("index session is already closed");
        }
        List futures = this.masterIndexStorage.getExecutorService().invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < openSessions.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("close succeeded for %s session", openSessions.get(i)));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.error(String.format("close failed for %s session", openSessions.get(i)), t);
            }
        }
        if (!success) {
            throw new Exception("begin failed");
        }
    }

    private static class CloseCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        CloseCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.close();
            return null;
        }
    }

    private static class RollbackCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        RollbackCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.rollback();
            return null;
        }
    }

    private class RestoreCallable
    implements Callable<Object> {
        private final Logger restoreLog = LoggerFactory.getLogger((String)String.format("%s.%s", MasterIndexPhysicalStorageSession.class.getName(), "RESTORE"));
        private final PhysicalStorage storage;
        private final String id;
        private final String user;

        RestoreCallable(PhysicalStorage storage, String id, String user) {
            this.storage = storage;
            this.id = id;
            this.user = user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            this.restoreLog.debug(String.format("|%s| BEGIN restore", this.id));
            LogicalStorage.get().setUser(this.user);
            this.restoreLog.debug(String.format("|%s| set user %s", this.id, this.user));
            try {
                PhysicalStorageSession session = null;
                try {
                    session = this.storage.createSession(MasterIndexPhysicalStorageSession.this.context);
                }
                catch (Exception e) {
                    this.restoreLog.error("unable to create session", (Throwable)e);
                    throw e;
                }
                try {
                    this.restoreLog.debug(String.format("|%s| rollback session created", this.id));
                    session.begin();
                    this.restoreLog.debug(String.format("|%s| rollback session opened", this.id));
                    try {
                        int operationsSize = MasterIndexPhysicalStorageSession.this.operations.size();
                        for (int i = operationsSize - 1; i >= 0; --i) {
                            PhysicalStorageOperation operation = MasterIndexPhysicalStorageSession.this.operations.get(i);
                            operation.restore(this.storage, session);
                            this.restoreLog.debug(String.format("|%s| operation restored (%d of %d) // %s", this.id, i + 1, operationsSize, operation.toString()));
                        }
                        session.commit();
                        this.restoreLog.debug(String.format("|%s| rollback session commit succeeded", this.id));
                    }
                    catch (Throwable t) {
                        this.restoreLog.error(String.format("|%s| rollback session commit failed", this.id), t);
                        session.rollback();
                        this.restoreLog.debug(String.format("|%s| rollback session rollback succeeded", this.id));
                        throw new Exception("failed", t);
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    this.restoreLog.debug(String.format("|%s| rollback session closed", this.id));
                    throw throwable;
                }
                session.close();
                this.restoreLog.debug(String.format("|%s| rollback session closed", this.id));
            }
            catch (Throwable throwable) {
                this.restoreLog.debug(String.format("|%s| END restore", this.id));
                throw throwable;
            }
            this.restoreLog.debug(String.format("|%s| END restore", this.id));
            return null;
        }
    }

    private class CommitCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;
        private final String id;
        private final String user;

        CommitCallable(PhysicalStorageSession session, String id, String user) {
            this.session = session;
            this.id = id;
            this.user = user;
        }

        @Override
        public Object call() throws Exception {
            MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| BEGIN commit", this.id));
            try {
                LogicalStorage.get().setUser(this.user);
                MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| set user %s", this.id, this.user));
                try {
                    this.session.commit();
                    MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| session commit succeeded", this.id));
                }
                catch (Throwable t) {
                    MasterIndexPhysicalStorageSession.this.log.error(String.format("|%s| session commit failed", this.id), t);
                    this.session.rollback();
                    MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| session rollback succeeded", this.id));
                    throw new Exception("failed", t);
                }
            }
            catch (Throwable throwable) {
                MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| END commit", this.id));
                throw throwable;
            }
            MasterIndexPhysicalStorageSession.this.log.debug(String.format("|%s| END commit", this.id));
            return null;
        }
    }

    private static class BeginCallable
    implements Callable<Object> {
        private final PhysicalStorageSession session;

        BeginCallable(PhysicalStorageSession session) {
            this.session = session;
        }

        @Override
        public Object call() throws Exception {
            this.session.begin();
            return null;
        }
    }
}

