/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class AssetStorageSaveAssetOperation<A extends BaseAsset>
implements PhysicalStorageOperation {
    private final PhysicalAssetData<A> asset;
    private final PhysicalAssetData<A> restoreData;

    public AssetStorageSaveAssetOperation(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData) throws Exception {
        this.asset = CloneHelper.clone(asset);
        this.restoreData = CloneHelper.clone(restoreData);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getAssetStorage().saveAsset(this.asset, this.restoreData, session);
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.restoreData == null) {
            storage.getAssetStorage().deleteAsset(this.asset, session);
            return;
        }
        storage.getAssetStorage().saveAsset(this.restoreData, this.asset, session);
    }

    public String toString() {
        return "AssetStorage.saveAsset(...)";
    }
}

