/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class BulkDictionaryStorageDeleteDataOperation<D extends BaseDictionary>
implements PhysicalStorageOperation {
    private final PhysicalBulkDictionaryData<D> data;

    public BulkDictionaryStorageDeleteDataOperation(PhysicalBulkDictionaryData<D> data) {
        this.data = CloneHelper.clone(data);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getBulkDictionaryStorage().deleteData(this.data, session);
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getBulkDictionaryStorage().updateData(this.data, null, session);
    }

    public String toString() {
        return "BulkDictionaryStorage.deleteData(...)";
    }
}

