/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class BulkDictionaryStorageUpdateDataOperation<D extends BaseDictionary>
implements PhysicalStorageOperation {
    private final PhysicalBulkDictionaryData<D> data;
    private final PhysicalBulkDictionaryData<D> restoreData;

    public BulkDictionaryStorageUpdateDataOperation(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData) {
        this.data = CloneHelper.clone(data);
        this.restoreData = CloneHelper.clone(restoreData);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getBulkDictionaryStorage().updateData(this.data, this.restoreData, session);
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.restoreData == null) {
            storage.getBulkDictionaryStorage().deleteData(this.data, session);
            return;
        }
        storage.getBulkDictionaryStorage().updateData(this.restoreData, this.data, session);
    }

    public String toString() {
        return "BulkDictionaryStorage.updateData(...)";
    }
}

