/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class DictionaryStorageSaveDictionaryOperation<D extends BaseDictionary>
implements PhysicalStorageOperation {
    private final PhysicalDictionaryData<D> data;
    private final PhysicalDictionaryData<D> oldData;

    public DictionaryStorageSaveDictionaryOperation(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData) {
        this.data = CloneHelper.clone(data);
        this.oldData = CloneHelper.clone(oldData);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getDictionaryStorage().saveDictionary(this.data, this.oldData, session);
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.oldData == null) {
            storage.getDictionaryStorage().deleteDictionary(this.data, session);
            return;
        }
        storage.getDictionaryStorage().saveDictionary(this.oldData, this.data, session);
    }

    public String toString() {
        return "DictionaryStorage.saveDictionary(...)";
    }
}

