/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class EntityStorageDeleteEntityOperation<E extends BaseEntity>
implements PhysicalStorageOperation {
    private final PhysicalEntityData<E> data;

    public EntityStorageDeleteEntityOperation(PhysicalEntityData<E> data) {
        this.data = CloneHelper.clone(data);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.data != null) {
            storage.getEntityStorage().deleteEntity(this.data, session);
        }
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.data != null) {
            storage.getEntityStorage().saveEntity(this.data, null, session);
        }
    }

    public String toString() {
        return "EntityStorage.deleteEntity(...)";
    }
}

