/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class EntityStorageDeleteVersionOperation<E extends BaseEntity>
implements PhysicalStorageOperation {
    private final PhysicalEntityData<E> data;
    private final int versionNumber;
    private final PhysicalEntityData<E> restoreData;

    public EntityStorageDeleteVersionOperation(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData) {
        this.data = CloneHelper.clone(data);
        this.versionNumber = versionNumber;
        this.restoreData = CloneHelper.clone(restoreData);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getEntityStorage().deleteVersion(this.data, this.versionNumber, this.restoreData, session);
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        storage.getEntityStorage().saveEntity(this.restoreData, this.data, session);
    }

    public String toString() {
        return "EntityStorage.deleteVersion(...)";
    }
}

