/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.CloneHelper;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;

public class EntityStorageSaveEntityOperation<E extends BaseEntity>
implements PhysicalStorageOperation {
    private final PhysicalEntityData<E> etc;
    private final PhysicalEntityData<E> restoreData;

    public EntityStorageSaveEntityOperation(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData) {
        this.etc = CloneHelper.clone(etc);
        this.restoreData = CloneHelper.clone(restoreData);
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.etc != null) {
            storage.getEntityStorage().saveEntity(this.etc, this.restoreData, session);
        }
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.restoreData != null) {
            storage.getEntityStorage().saveEntity(this.restoreData, this.etc, session);
            return;
        }
        storage.getEntityStorage().deleteEntity(this.etc, session);
    }

    public String toString() {
        return "EntityStorage.saveEntity(...)";
    }
}

