/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.operation;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.operation.PhysicalStorageOperation;
import java.util.List;
import java.util.Map;

public class EntityStorageSaveIndexesOperation<E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>>
implements PhysicalStorageOperation {
    private final Class<I> cls;
    private final Map<EntityPhysicalStorage, List<D>> indexes;
    private final String containerUid;

    public EntityStorageSaveIndexesOperation(Class<I> cls, Map<EntityPhysicalStorage, List<D>> indexes, String containerUid) {
        this.cls = cls;
        this.indexes = indexes;
        this.containerUid = containerUid;
    }

    @Override
    public void execute(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (this.indexes != null && !this.indexes.isEmpty()) {
            storage.getEntityStorage().saveIndexes(this.cls, this.indexes, this.containerUid, session);
        }
    }

    @Override
    public void restore(PhysicalStorage storage, PhysicalStorageSession session) throws Exception {
        if (!TextUtil.isBlank((String)this.containerUid)) {
            storage.getEntityStorage().deleteIndexes(this.cls, this.containerUid, this.indexes, session);
        }
    }

    public String toString() {
        return "EntityStorage.saveIndexes(...)";
    }
}

